/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.naivebayes;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import opennlp.tools.ml.AbstractMLModelWriter;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.ComparablePredicate;
import opennlp.tools.ml.model.Context;

public abstract class NaiveBayesModelWriter
extends AbstractMLModelWriter {
    public NaiveBayesModelWriter(AbstractModel model) {
        Object[] data = model.getDataStructures();
        this.numOutcomes = model.getNumOutcomes();
        this.PARAMS = (Context[])data[0];
        Map pmap = (Map)data[1];
        this.OUTCOME_LABELS = (String[])data[2];
        this.PARAMS = new Context[pmap.size()];
        this.PRED_LABELS = new String[pmap.size()];
        int i = 0;
        for (Map.Entry pred : pmap.entrySet()) {
            this.PRED_LABELS[i] = (String)pred.getKey();
            this.PARAMS[i] = (Context)pred.getValue();
            ++i;
        }
    }

    protected ComparablePredicate[] sortValues() {
        Object[] sortPreds = new ComparablePredicate[this.PARAMS.length];
        int numParams = 0;
        for (int pid = 0; pid < this.PARAMS.length; ++pid) {
            int[] predkeys = this.PARAMS[pid].getOutcomes();
            int numActive = predkeys.length;
            double[] activeParams = this.PARAMS[pid].getParameters();
            numParams += numActive;
            sortPreds[pid] = new ComparablePredicate(this.PRED_LABELS[pid], predkeys, activeParams);
        }
        Arrays.sort(sortPreds);
        return sortPreds;
    }

    public void persist() throws IOException {
        this.writeUTF("NaiveBayes");
        super.persist();
    }
}

