/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.IOException;
import java.util.Collections;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.Sequence;
import opennlp.tools.ml.model.SequenceStream;
import opennlp.tools.namefind.BioCodec;
import opennlp.tools.namefind.DefaultNameContextGenerator;
import opennlp.tools.namefind.NameContextGenerator;
import opennlp.tools.namefind.NameFinderEventStream;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;

public class NameSampleSequenceStream
implements SequenceStream<NameSample> {
    private final NameContextGenerator pcg;
    private final boolean useOutcomes;
    private final ObjectStream<NameSample> psi;
    private final SequenceCodec<String> seqCodec;

    public NameSampleSequenceStream(ObjectStream<NameSample> psi) {
        this(psi, new DefaultNameContextGenerator(new AdaptiveFeatureGenerator[]{null}), true);
    }

    public NameSampleSequenceStream(ObjectStream<NameSample> psi, AdaptiveFeatureGenerator featureGen) {
        this(psi, new DefaultNameContextGenerator(featureGen), true);
    }

    public NameSampleSequenceStream(ObjectStream<NameSample> psi, AdaptiveFeatureGenerator featureGen, boolean useOutcomes) {
        this(psi, new DefaultNameContextGenerator(featureGen), useOutcomes);
    }

    public NameSampleSequenceStream(ObjectStream<NameSample> psi, NameContextGenerator pcg) {
        this(psi, pcg, true);
    }

    public NameSampleSequenceStream(ObjectStream<NameSample> psi, NameContextGenerator pcg, boolean useOutcomes) {
        this(psi, pcg, useOutcomes, new BioCodec());
    }

    public NameSampleSequenceStream(ObjectStream<NameSample> psi, NameContextGenerator pcg, boolean useOutcomes, SequenceCodec<String> seqCodec) {
        this.psi = psi;
        this.useOutcomes = useOutcomes;
        this.pcg = pcg;
        this.seqCodec = seqCodec;
    }

    public Event[] updateContext(Sequence<NameSample> sequence, MaxentModel model) {
        NameFinderME tagger = new NameFinderME(new TokenNameFinderModel("x-unspecified", model, Collections.emptyMap(), null));
        String[] sentence = ((NameSample)sequence.getSource()).getSentence();
        String[] tags = (String[])this.seqCodec.encode(tagger.find(sentence), sentence.length);
        Event[] events = new Event[sentence.length];
        NameFinderEventStream.generateEvents(sentence, tags, this.pcg).toArray(events);
        return events;
    }

    public Sequence<NameSample> read() throws IOException {
        NameSample sample = (NameSample)this.psi.read();
        if (sample != null) {
            Object[] sentence = sample.getSentence();
            String[] tags = (String[])this.seqCodec.encode(sample.getNames(), sentence.length);
            Event[] events = new Event[sentence.length];
            for (int i = 0; i < sentence.length; ++i) {
                CharSequence[] context = this.useOutcomes ? this.pcg.getContext(i, sentence, tags, null) : this.pcg.getContext(i, sentence, null, null);
                events[i] = new Event(tags[i], context);
            }
            return new Sequence(events, (Object)sample);
        }
        return null;
    }

    public void reset() throws IOException, UnsupportedOperationException {
        this.psi.reset();
    }

    public void close() throws IOException {
        this.psi.close();
    }
}

