/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.IOException;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.TokenizerEvaluationMonitor;
import opennlp.tools.tokenize.TokenizerEvaluator;
import opennlp.tools.tokenize.TokenizerFactory;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.eval.CrossValidationPartitioner;
import opennlp.tools.util.eval.FMeasure;

public class TokenizerCrossValidator {
    private final TrainingParameters params;
    private final FMeasure fmeasure = new FMeasure();
    private final TokenizerEvaluationMonitor[] listeners;
    private final TokenizerFactory factory;

    public TokenizerCrossValidator(TrainingParameters params, TokenizerFactory factory, TokenizerEvaluationMonitor ... listeners) {
        this.params = params;
        this.listeners = listeners;
        this.factory = factory;
    }

    public void evaluate(ObjectStream<TokenSample> samples, int nFolds) throws IOException {
        CrossValidationPartitioner<TokenSample> partitioner = new CrossValidationPartitioner<TokenSample>(samples, nFolds);
        while (partitioner.hasNext()) {
            CrossValidationPartitioner.TrainingSampleStream<TokenSample> trainingSampleStream = partitioner.next();
            TokenizerModel model = TokenizerME.train(trainingSampleStream, this.factory, this.params);
            TokenizerEvaluator evaluator = new TokenizerEvaluator((Tokenizer)new TokenizerME(model), this.listeners);
            evaluator.evaluate(trainingSampleStream.getTestSampleStream());
            this.fmeasure.mergeInto(evaluator.getFMeasure());
        }
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }
}

