/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.BioNLP2004NameSampleStream;
import opennlp.tools.formats.FormatUtil;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.ObjectStream;

public class BioNLP2004NameSampleStreamFactory
extends AbstractSampleStreamFactory<NameSample, Parameters> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(NameSample.class, "bionlp2004", new BioNLP2004NameSampleStreamFactory(Parameters.class));
    }

    protected BioNLP2004NameSampleStreamFactory(Class<Parameters> params) {
        super(params);
    }

    public ObjectStream<NameSample> create(String[] args) {
        Parameters params = this.validateBasicFormatParameters(args, Parameters.class);
        int typesToGenerate = 0;
        String types = params.getTypes();
        if (types.contains("DNA")) {
            typesToGenerate |= 1;
        }
        if (types.contains("protein")) {
            typesToGenerate |= 2;
        }
        if (types.contains("cell_type")) {
            typesToGenerate |= 4;
        }
        if (types.contains("cell_line")) {
            typesToGenerate |= 8;
        }
        if (types.contains("RNA")) {
            typesToGenerate |= 0x10;
        }
        try {
            return new BioNLP2004NameSampleStream(FormatUtil.createInputStreamFactory(params.getData()), typesToGenerate);
        }
        catch (IOException ex) {
            throw new TerminateToolException(-1, "IO Error while creating an Input Stream: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public static interface Parameters
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="DNA,protein,cell_type,cell_line,RNA")
        public String getTypes();
    }
}

