/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.masc;

import java.io.IOException;
import java.util.ArrayList;
import opennlp.tools.formats.masc.MascDocument;
import opennlp.tools.formats.masc.MascSentence;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

public class MascSentenceSampleStream
extends FilterObjectStream<MascDocument, SentenceSample> {
    private final int sentencesPerSample;
    private MascDocument buffer;

    public MascSentenceSampleStream(ObjectStream<MascDocument> samples, int sentencesPerSample) throws IOException {
        super(samples);
        this.sentencesPerSample = sentencesPerSample;
        this.buffer = (MascDocument)samples.read();
    }

    public SentenceSample read() throws IOException {
        try {
            StringBuilder documentText = new StringBuilder();
            ArrayList<Span> sentenceSpans = new ArrayList<Span>();
            for (int i = 0; i < this.sentencesPerSample; ++i) {
                MascSentence sentence = this.buffer.read();
                if (sentence != null) {
                    int startIndex = documentText.length();
                    documentText.append(sentence.getSentDetectText()).append(' ');
                    sentenceSpans.add(new Span(startIndex, documentText.length() - 1));
                    continue;
                }
                this.buffer = (MascDocument)this.samples.read();
                if (this.buffer == null) break;
                documentText.append('\n');
                --i;
            }
            if (documentText.length() > 0) {
                documentText.setLength(documentText.length() - 1);
                return new SentenceSample((CharSequence)documentText, sentenceSpans.toArray(new Span[0]));
            }
            return null;
        }
        catch (IOException e) {
            throw new IOException("You are reading an empty document stream. Did you close it?");
        }
    }

    public void reset() throws IOException, UnsupportedOperationException {
        this.samples.reset();
        this.buffer = (MascDocument)this.samples.read();
    }
}

