/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.nio.ByteBuffer;
import org.apache.qpid.QpidException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.ServerChannelMethodProcessor;
import org.apache.qpid.util.ByteBufferUtils;

public class BasicGetBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 60;
    public static final int METHOD_ID = 70;
    private final int _ticket;
    private final AMQShortString _queue;
    private final byte _bitfield0;

    public BasicGetBody(int ticket, AMQShortString queue, boolean noAck) {
        this._ticket = ticket;
        this._queue = queue;
        byte bitfield0 = 0;
        if (noAck) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 60;
    }

    @Override
    public int getMethod() {
        return 70;
    }

    public final int getTicket() {
        return this._ticket;
    }

    public final AMQShortString getQueue() {
        return this._queue;
    }

    public final boolean getNoAck() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 3;
        return size += this.getSizeOf(this._queue);
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._queue);
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchBasicGet(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[BasicGetBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append(", ");
        buf.append("noAck=");
        buf.append(this.getNoAck());
        buf.append("]");
        return buf.toString();
    }

    public static void process(ByteBuffer buffer, ServerChannelMethodProcessor dispatcher) {
        boolean noAck;
        int ticket = ByteBufferUtils.getUnsignedShort(buffer);
        AMQShortString queue = AMQShortString.readAMQShortString(buffer);
        boolean bl = noAck = (buffer.get() & 1) != 0;
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveBasicGet(queue, noAck);
        }
    }
}

