/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.refresh;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.net.URI;
import java.util.List;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.http.client.common.AbstractAddressManager;
import org.apache.servicecomb.http.client.event.RefreshEndpointEvent;

public class ServiceRegistryAddressManager
extends AbstractAddressManager {
    private static final String URI_PREFIX = "rest://";

    public ServiceRegistryAddressManager(List<String> addresses, EventBus eventBus) {
        super(addresses);
        eventBus.register((Object)this);
    }

    public IpPort getAvailableIpPort() {
        return this.transformIpPort(this.address());
    }

    protected String normalizeUri(String endpoint) {
        return new URIEndpointObject(endpoint).toString();
    }

    public IpPort transformIpPort(String address) {
        URI uri = URI.create(URI_PREFIX + address);
        return new IpPort(uri.getHost(), uri.getPort());
    }

    @Subscribe
    public void onRefreshEndpointEvent(RefreshEndpointEvent event) {
        this.refreshEndpoint(event, "SERVICECENTER");
    }
}

