/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.loadbalance.RuleExt;
import org.apache.servicecomb.loadbalance.ServerListFilterExt;
import org.apache.servicecomb.loadbalance.ServiceCombServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadBalancer.class);
    private static final AtomicInteger id = new AtomicInteger(0);
    private final RuleExt rule;
    private final String microServiceName;
    private List<ServerListFilterExt> filters;

    public LoadBalancer(RuleExt rule, String microServiceName) {
        this.microServiceName = microServiceName;
        this.rule = rule;
        this.filters = SPIServiceUtils.loadSortedService(ServerListFilterExt.class);
        this.rule.setLoadBalancer(this);
        this.filters.forEach(item -> item.setLoadBalancer(this));
    }

    public ServiceCombServer chooseServer(Invocation invocation) {
        ServiceCombServer server;
        List<ServiceCombServer> servers = (List<ServiceCombServer>)invocation.getLocalContext("x-context-server-list");
        int serversCount = servers.size();
        for (ServerListFilterExt filterExt : this.filters) {
            if (!filterExt.enabled() || !(servers = filterExt.getFilteredListOfServers(servers, invocation)).isEmpty() || serversCount <= 0) continue;
            LOGGER.warn("There are not servers exist after filtered by {}.", filterExt.getClass());
            break;
        }
        if (null == (server = this.rule.choose(servers, invocation))) {
            return null;
        }
        return server;
    }

    public String getMicroServiceName() {
        return this.microServiceName;
    }

    @VisibleForTesting
    void setFilters(List<ServerListFilterExt> filters) {
        this.filters = filters;
    }
}

