/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.jcr;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.vault.davex.DAVExRepositoryFactory;
import org.apache.jackrabbit.vault.fs.api.RepositoryAddress;
import org.apache.jackrabbit.vault.fs.api.RepositoryFactory;
import org.apache.sling.ide.transport.RepositoryInfo;

public abstract class RepositoryUtils {
    private static final Object SYNC = new Object();
    static final String[] WEBDAV_URL_LOCATIONS = new String[]{"server/default/jcr:root", "crx/server/crx.default/jcr:root"};
    private static final RepositoryFactory FACTORY = new DAVExRepositoryFactory();
    private static final Map<RepositoryAddress, Repository> REGISTERED_REPOSITORIES = new HashMap<RepositoryAddress, Repository>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Repository getRepository(RepositoryInfo repositoryInfo) throws RepositoryException {
        RepositoryAddress repositoryAddress = RepositoryUtils.getRepositoryAddress(repositoryInfo);
        Object object = SYNC;
        synchronized (object) {
            return REGISTERED_REPOSITORIES.get(repositoryAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RepositoryAddress getRepositoryAddress(RepositoryInfo repositoryInfo) {
        StringBuilder errors = new StringBuilder();
        for (String webDavUrlLocation : WEBDAV_URL_LOCATIONS) {
            Session session = null;
            URI url = repositoryInfo.getUrl().resolve(webDavUrlLocation);
            try {
                Repository repository;
                RepositoryAddress address = new RepositoryAddress(url);
                Object object = SYNC;
                synchronized (object) {
                    repository = REGISTERED_REPOSITORIES.get(address);
                    if (repository == null) {
                        Set<String> supportedSchemes = FACTORY.getSupportedSchemes();
                        if (!supportedSchemes.contains(address.getURI().getScheme())) {
                            throw new IllegalArgumentException("Unable to create a a repository for " + String.valueOf(address.getURI()) + ", since the scheme is unsupported. Only schemes '" + String.valueOf(supportedSchemes) + "' are supported");
                        }
                        ClassLoader old = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(Repository.class.getClassLoader());
                        try {
                            repository = FACTORY.createRepository(address);
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(old);
                        }
                        REGISTERED_REPOSITORIES.put(address, repository);
                    }
                }
                session = repository.login(new SimpleCredentials(repositoryInfo.getUsername(), repositoryInfo.getPassword().toCharArray()));
                object = address;
                return object;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            catch (RepositoryException e) {
                errors.append(url).append(" : ").append(e.getMessage()).append('\n');
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
        errors.deleteCharAt(errors.length() - 1);
        throw new IllegalArgumentException("No repository found at " + String.valueOf(repositoryInfo.getUrl()) + "\n" + errors.toString());
    }

    public static Credentials getCredentials(RepositoryInfo repositoryInfo) {
        return new SimpleCredentials(repositoryInfo.getUsername(), repositoryInfo.getPassword().toCharArray());
    }

    private RepositoryUtils() {
    }
}

