/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterPipe
extends BasePipe {
    private static Logger logger = LoggerFactory.getLogger(FilterPipe.class);
    public static final String RESOURCE_TYPE = "slingPipes/filter";
    public static final String PREFIX_FILTER = "slingPipesFilter_";
    public static final String PN_NOT = "slingPipesFilter_not";
    public static final String PN_NOCHILDREN = "slingPipesFilter_noChildren";
    public static final String PN_TEST = "slingPipesFilter_test";
    public static final String PN_INJECTCHILDRENCOUNT = "slingPipesFilter_injectChildrenCount";
    public static final String BINDING_CHILDREN_COUNT = "childrenCount";
    Map<String, Pattern> propertiesPatterns;

    public FilterPipe(Plumber plumber, Resource resource, PipeBindings upperBindings) {
        super(plumber, resource, upperBindings);
    }

    Pattern getPattern(Resource filterResource, String propertyKey) {
        if (this.propertiesPatterns == null) {
            this.propertiesPatterns = new HashMap<String, Pattern>();
        }
        String key = filterResource.getPath() + "/" + propertyKey;
        return this.propertiesPatterns.computeIfAbsent(key, x -> {
            String value = this.getBindings().instantiateExpression((String)filterResource.getValueMap().get(propertyKey, String.class));
            return value != null ? Pattern.compile(value) : null;
        });
    }

    boolean propertiesPass(ValueMap current, Resource filterResource) {
        ValueMap filter = filterResource.getValueMap();
        if (filter.containsKey((Object)PN_TEST)) {
            Object test = this.bindings.instantiateObject((String)filter.get(PN_TEST, (Object)"${false}"));
            if (!(test instanceof Boolean)) {
                logger.error("instantiated test {} is not a boolean, filtering out", test);
                return false;
            }
            return (Boolean)test;
        }
        for (String key : filter.keySet()) {
            if (IGNORED_PROPERTIES.contains(key) || key.startsWith(PREFIX_FILTER)) continue;
            Pattern pattern = this.getPattern(filterResource, key);
            if (current.containsKey((Object)key) && pattern.matcher((CharSequence)current.get(key, String.class)).matches()) continue;
            return false;
        }
        return true;
    }

    boolean hasNoChildrenFilter(ValueMap filter) {
        return (Boolean)this.bindings.instantiateObject((String)filter.get(PN_NOCHILDREN, (Object)"${false}"));
    }

    boolean iterateOverChildren(Resource currentResource, Resource filterResource) throws RepositoryException {
        Node filterNode = (Node)filterResource.adaptTo(Node.class);
        Node currentNode = (Node)currentResource.adaptTo(Node.class);
        if (filterNode != null) {
            boolean returnValue;
            String childName;
            NodeIterator children = filterNode.getNodes();
            for (returnValue = true; returnValue && children.hasNext(); returnValue &= this.filterPasses(currentResource.getChild(childName), filterResource.getChild(childName))) {
                childName = children.nextNode().getName();
                if (currentNode == null || currentNode.hasNode(childName)) continue;
                return false;
            }
            return returnValue;
        }
        return false;
    }

    boolean childrenPass(Resource currentResource, Resource filterResource) throws RepositoryException {
        Node currentNode = (Node)currentResource.adaptTo(Node.class);
        if (currentNode != null) {
            if (this.hasNoChildrenFilter(filterResource.getValueMap())) {
                return !currentNode.hasNodes();
            }
            return this.iterateOverChildren(currentResource, filterResource);
        }
        return false;
    }

    boolean filterPasses(Resource currentResource, Resource filterResource) throws RepositoryException {
        if (currentResource != null && filterResource != null) {
            Node currentNode;
            ValueMap current = currentResource.getValueMap();
            ValueMap filter = filterResource.getValueMap();
            boolean injectChildrenCount = (Boolean)this.bindings.instantiateObject((String)filter.get(PN_INJECTCHILDRENCOUNT, (Object)"${false}"));
            if (injectChildrenCount && (currentNode = (Node)currentResource.adaptTo(Node.class)) != null) {
                int childrenCount = IteratorUtils.toList((Iterator)currentNode.getNodes()).size();
                this.bindings.addBinding(BINDING_CHILDREN_COUNT, childrenCount);
            }
            if (this.propertiesPass(current, filterResource)) {
                return this.childrenPass(currentResource, filterResource);
            }
        }
        return false;
    }

    @Override
    protected Iterator<Resource> computeOutput() {
        Resource resource = this.getInput();
        if (resource != null) {
            try {
                boolean not = this.getBindings().instantiateExpression((String)this.properties.get(PN_NOT, (Object)"false")).equals(Boolean.TRUE.toString());
                if (this.filterPasses(resource, this.getConfiguration()) ^ not) {
                    logger.debug("filter passes for {}", (Object)resource.getPath());
                    return super.computeOutput();
                }
                logger.debug("{} got filtered out", (Object)resource.getPath());
            }
            catch (RepositoryException e) {
                logger.error("unable to filter the input", (Throwable)e);
            }
        }
        return EMPTY_ITERATOR;
    }
}

