/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.columns;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.HashIntegerArray;
import org.apache.sysds.runtime.frame.data.columns.HashMapToInt;
import org.apache.sysds.runtime.frame.data.columns.IHashArray;
import org.apache.sysds.runtime.frame.data.columns.OptionalArray;
import org.apache.sysds.runtime.frame.data.columns.StringArray;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.MemoryEstimates;

public class HashLongArray
extends Array<Object>
implements IHashArray {
    private long[] _data;

    private HashLongArray(int nRow) {
        this(new long[nRow]);
    }

    public HashLongArray(long[] data) {
        super(data.length);
        this._data = data;
    }

    public HashLongArray(String[] data) {
        super(data.length);
        this._data = new long[data.length];
        for (int i = 0; i < data.length; ++i) {
            this._data[i] = HashLongArray.parseHashLong(data[i]);
        }
    }

    @Override
    public Object get() {
        throw new NotImplementedException("Invalid to get underlying array in Hash");
    }

    @Override
    public Object get(int index) {
        return Long.toHexString(this._data[index]);
    }

    @Override
    public Object getInternal(int index) {
        return this._data[index];
    }

    @Override
    public long getLong(int index) {
        return this._data[index];
    }

    @Override
    public int getInt(int index) {
        return (int)this._data[index];
    }

    protected long[] getLongs() {
        return this._data;
    }

    @Override
    public void set(int index, Object value) {
        if (value instanceof String) {
            this._data[index] = HashLongArray.parseHashLong((String)value);
        } else if (value instanceof Long) {
            this._data[index] = (Long)value;
        } else if (value == null) {
            this._data[index] = 0L;
        } else {
            throw new NotImplementedException("not supported : " + value);
        }
    }

    @Override
    public void set(int index, String value) {
        this._data[index] = HashLongArray.parseHashLong(value);
    }

    @Override
    public void set(int index, double value) {
        this._data[index] = (long)value;
    }

    @Override
    public void setFromOtherType(int rl, int ru, Array<?> value) {
        for (int i = rl; i <= ru; ++i) {
            this._data[i] = HashLongArray.parseHashLong(value.get(i));
        }
    }

    @Override
    public void setNz(int rl, int ru, Array<Object> value) {
        if (value instanceof HashLongArray) {
            long[] thatVals = ((HashLongArray)value)._data;
            for (int i = rl; i <= ru; ++i) {
                if (thatVals[i] == 0L) continue;
                this._data[i] = thatVals[i];
            }
        } else {
            throw new NotImplementedException("Not supported type of array: " + value.getClass().getSimpleName());
        }
    }

    @Override
    public void setFromOtherTypeNz(int rl, int ru, Array<?> value) {
        if (value instanceof HashLongArray) {
            this.setNz(rl, ru, (HashLongArray)value);
        } else if (value instanceof StringArray) {
            StringArray st = (StringArray)value;
            for (int i = rl; i <= ru; ++i) {
                if (st.get(i) == null) continue;
                this._data[i] = HashLongArray.parseHashLong(st.get(i));
            }
        } else {
            Types.ValueType vt = value.getValueType();
            for (int i = rl; i <= ru; ++i) {
                Object v = value.get(i);
                if (v == null) continue;
                this._data[i] = UtilFunctions.objectToLong(vt, v);
            }
        }
    }

    @Override
    public void append(Object value) {
        this.append(HashLongArray.parseHashLong(value));
    }

    @Override
    public void append(String value) {
        this.append(HashLongArray.parseHashLong(value));
    }

    @Override
    public void append(long value) {
        if (this._data.length <= this._size) {
            this._data = Arrays.copyOf(this._data, this.newSize());
        }
        this._data[this._size++] = value;
    }

    @Override
    public Array<Object> append(Array<Object> other) {
        if (other instanceof HashLongArray) {
            int endSize = this._size + other.size();
            long[] ret = new long[endSize];
            System.arraycopy(this._data, 0, ret, 0, this._size);
            System.arraycopy(((HashLongArray)other)._data, 0, ret, this._size, other.size());
            return new HashLongArray(ret);
        }
        if (other instanceof OptionalArray) {
            OptionalArray ot = (OptionalArray)other;
            if (ot._a instanceof HashLongArray) {
                Array<Object> a = this.append(ot._a);
                return OptionalArray.appendOther(ot, a);
            }
        }
        throw new NotImplementedException(other.getClass().getSimpleName() + " not append supported in hashColumn");
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(ArrayFactory.FrameArrayType.HASH64.ordinal());
        for (int i = 0; i < this._size; ++i) {
            out.writeLong(this._data[i]);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this._size = this._data.length;
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = in.readLong();
        }
    }

    protected static HashLongArray read(DataInput in, int nRow) throws IOException {
        HashLongArray arr = new HashLongArray(nRow);
        arr.readFields(in);
        return arr;
    }

    @Override
    public Array<Object> clone() {
        return new HashLongArray(Arrays.copyOf(this._data, this._size));
    }

    @Override
    public Array<Object> slice(int rl, int ru) {
        return new HashLongArray(Arrays.copyOfRange(this._data, rl, ru));
    }

    @Override
    public void reset(int size) {
        if (this._data.length < size || this._data.length > 2 * size) {
            this._data = new long[size];
        } else {
            for (int i = 0; i < size; ++i) {
                this._data[i] = 0L;
            }
        }
        this._size = size;
    }

    @Override
    public byte[] getAsByteArray() {
        throw new NotImplementedException("Unclear how this byte array should look like for Hash");
    }

    @Override
    public Types.ValueType getValueType() {
        return Types.ValueType.HASH64;
    }

    @Override
    public Pair<Types.ValueType, Boolean> analyzeValueType(int maxCells) {
        return new Pair<Types.ValueType, Boolean>(Types.ValueType.HASH64, false);
    }

    @Override
    public ArrayFactory.FrameArrayType getFrameArrayType() {
        return ArrayFactory.FrameArrayType.HASH64;
    }

    @Override
    public long getInMemorySize() {
        long size = super.getInMemorySize();
        size = (long)((double)size + MemoryEstimates.longArrayCost(this._data.length));
        return size;
    }

    @Override
    public long getExactSerializedSize() {
        return 1 + 8 * this._size;
    }

    @Override
    protected Array<Boolean> changeTypeBitSet(Array<Boolean> ret, int l, int u) {
        for (int i = l; i < u; ++i) {
            if (this._data[i] != 0L && this._data[i] != 1L) {
                throw new DMLRuntimeException("Unable to change to Boolean from Hash array because of value:" + this._data[i]);
            }
            ret.set(i, this._data[i] != 0L);
        }
        return ret;
    }

    @Override
    protected Array<Boolean> changeTypeBoolean(Array<Boolean> retA, int l, int u) {
        boolean[] ret = (boolean[])retA.get();
        for (int i = l; i < u; ++i) {
            if (this._data[i] != 0L && this._data[i] != 1L) {
                throw new DMLRuntimeException("Unable to change to Boolean from Hash array because of value:" + this._data[i]);
            }
            ret[i] = this._data[i] != 0L;
        }
        return retA;
    }

    @Override
    protected Array<Double> changeTypeDouble(Array<Double> retA, int l, int u) {
        double[] ret = (double[])retA.get();
        for (int i = l; i < u; ++i) {
            ret[i] = this._data[i];
        }
        return retA;
    }

    @Override
    protected Array<Float> changeTypeFloat(Array<Float> retA, int l, int u) {
        float[] ret = (float[])retA.get();
        for (int i = l; i < u; ++i) {
            ret[i] = this._data[i];
        }
        return retA;
    }

    @Override
    protected Array<Integer> changeTypeInteger(Array<Integer> retA, int l, int u) {
        int[] ret = (int[])retA.get();
        for (int i = l; i < u; ++i) {
            ret[i] = (int)this._data[i];
        }
        return retA;
    }

    @Override
    protected Array<Long> changeTypeLong(Array<Long> retA, int l, int u) {
        long[] ret = (long[])retA.get();
        for (int i = l; i < u; ++i) {
            ret[i] = this._data[i];
        }
        return retA;
    }

    @Override
    protected Array<Object> changeTypeHash64(Array<Object> retA, int l, int u) {
        long[] ret = ((HashLongArray)retA).getLongs();
        for (int i = l; i < u; ++i) {
            ret[i] = this._data[i];
        }
        return retA;
    }

    @Override
    protected Array<Object> changeTypeHash32(Array<Object> retA, int l, int u) {
        int[] ret = ((HashIntegerArray)retA).getInts();
        for (int i = l; i < u; ++i) {
            ret[i] = (int)this._data[i];
        }
        return retA;
    }

    @Override
    protected Array<String> changeTypeString(Array<String> retA, int l, int u) {
        String[] ret = (String[])retA.get();
        for (int i = l; i < u; ++i) {
            ret[i] = this.get(i).toString();
        }
        return retA;
    }

    @Override
    public Array<Character> changeTypeCharacter(Array<Character> retA, int l, int u) {
        char[] ret = (char[])retA.get();
        for (int i = l; i < u; ++i) {
            ret[i] = this.get(i).toString().charAt(0);
        }
        return retA;
    }

    @Override
    public void fill(String value) {
        this.fill(HashLongArray.parseHashLong(value));
    }

    @Override
    public void fill(Object value) {
        this.fill(HashLongArray.parseHashLong(value));
    }

    @Override
    private void fill(long value) {
        Arrays.fill(this._data, value);
    }

    @Override
    public double getAsDouble(int i) {
        return this._data[i];
    }

    public static long parseHashLong(Object s) {
        if (s == null) {
            return 0L;
        }
        if (s instanceof String) {
            return HashLongArray.parseHashLong((String)s);
        }
        if (s instanceof Long) {
            return (Long)s;
        }
        if (s instanceof Integer) {
            return ((Integer)s).intValue();
        }
        throw new NotImplementedException("not supported" + s);
    }

    public static long parseHashLong(String s) {
        if (s == null || s.isEmpty()) {
            return 0L;
        }
        return Long.parseUnsignedLong(s, 16);
    }

    @Override
    public boolean isShallowSerialize() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this._size; ++i) {
            if (this._data[i] == 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public Array<Object> select(int[] indices) {
        long[] ret = new long[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            ret[i] = this._data[indices[i]];
        }
        return new HashLongArray(ret);
    }

    @Override
    public Array<Object> select(boolean[] select, int nTrue) {
        long[] ret = new long[nTrue];
        int k = 0;
        for (int i = 0; i < select.length; ++i) {
            if (!select[i]) continue;
            ret[k++] = this._data[i];
        }
        return new HashLongArray(ret);
    }

    @Override
    public final boolean isNotEmpty(int i) {
        return this._data[i] != 0L;
    }

    @Override
    public double hashDouble(int idx) {
        return Long.hashCode(this._data[idx]);
    }

    @Override
    public boolean equals(Array<Object> other) {
        if (other instanceof HashLongArray) {
            return Arrays.equals(this._data, ((HashLongArray)other)._data);
        }
        return false;
    }

    @Override
    public boolean possiblyContainsNaN() {
        return false;
    }

    @Override
    public void setM(HashMapToInt<Object> map, AMapToData m, int i) {
        m.set(i, map.get(this.getLong(i)) - 1);
    }

    @Override
    public void setM(HashMapToInt<Object> map, int si, AMapToData m, int i) {
        m.set(i, map.get(this.getLong(i)) - 1);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this._size * 5 + 2);
        sb.append(super.toString() + ":[");
        for (int i = 0; i < this._size - 1; ++i) {
            sb.append(this._data[i] + ",");
        }
        sb.append(this._data[this._size - 1]);
        sb.append("]");
        return sb.toString();
    }
}

