/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import java.util.concurrent.Future;
import org.apache.sysds.common.Opcodes;
import org.apache.sysds.hops.fedplanner.FTypes;
import org.apache.sysds.lops.MMTSJ;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.MMTSJCPInstruction;
import org.apache.sysds.runtime.instructions.fed.BinaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class TsmmFEDInstruction
extends BinaryFEDInstruction {
    private final MMTSJ.MMTSJType _type;
    private final int _numThreads;

    public TsmmFEDInstruction(CPOperand in, CPOperand out, MMTSJ.MMTSJType type, int k, String opcode, String istr, FEDInstruction.FederatedOutput fedOut) {
        super(FEDInstruction.FEDType.Tsmm, null, in, null, out, opcode, istr, fedOut);
        this._type = type;
        this._numThreads = k;
    }

    public TsmmFEDInstruction(CPOperand in, CPOperand out, MMTSJ.MMTSJType type, int k, String opcode, String istr) {
        this(in, out, type, k, opcode, istr, FEDInstruction.FederatedOutput.NONE);
    }

    public static TsmmFEDInstruction parseInstruction(MMTSJCPInstruction inst, ExecutionContext ec) {
        MatrixObject mo = ec.getMatrixObject(inst.input1);
        if (mo.isFederated(FTypes.FType.ROW) && mo.isFederatedExcept(FTypes.FType.BROADCAST) && inst.getMMTSJType().isLeft() || mo.isFederated(FTypes.FType.COL) && mo.isFederatedExcept(FTypes.FType.BROADCAST) && inst.getMMTSJType().isRight()) {
            return TsmmFEDInstruction.parseInstruction(inst);
        }
        return null;
    }

    private static TsmmFEDInstruction parseInstruction(MMTSJCPInstruction instr) {
        return new TsmmFEDInstruction(instr.input1, instr.getOutput(), instr.getMMTSJType(), instr.getNumThreads(), instr.getOpcode(), instr.getInstructionString());
    }

    public static TsmmFEDInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equalsIgnoreCase(Opcodes.TSMM.toString())) {
            throw new DMLRuntimeException("TsmmFedInstruction.parseInstruction():: Unknown opcode " + opcode);
        }
        InstructionUtils.checkNumFields(parts, 3, 4, 5);
        CPOperand in = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        MMTSJ.MMTSJType type = MMTSJ.MMTSJType.valueOf(parts[3]);
        int k = parts.length > 4 ? Integer.parseInt(parts[4]) : -1;
        FEDInstruction.FederatedOutput fedOut = parts.length > 5 ? FEDInstruction.FederatedOutput.valueOf(parts[5]) : FEDInstruction.FederatedOutput.NONE;
        return new TsmmFEDInstruction(in, out, type, k, opcode, str, fedOut);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixObject mo1 = ec.getMatrixObject(this.input1);
        if (!(this._type.isLeft() && mo1.isFederated(FTypes.FType.ROW) || mo1.isFederated(FTypes.FType.COL) && this._type.isRight())) {
            String exMessage = !mo1.isFederated() || mo1.getFedMapping() == null ? "Federated Tsmm does not support non-federated input" : "Federated Tsmm does not support federated map type " + mo1.getFedMapping().getType();
            throw new DMLRuntimeException(exMessage);
        }
        this.processRowCol(ec, mo1);
    }

    private void processRowCol(ExecutionContext ec, MatrixObject mo1) {
        FederatedRequest fr1 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1}, new long[]{mo1.getFedMapping().getID()}, true);
        if (this._fedOut.isForcedFederated()) {
            fr1 = mo1.getFedMapping().broadcast(mo1);
            FederatedRequest fr2 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1}, new long[]{fr1.getID()}, true);
            mo1.getFedMapping().execute(this.getTID(), fr1, fr2);
            this.setOutputFederated(ec, mo1, fr2, FTypes.FType.BROADCAST);
        } else if (mo1.isFederated(FTypes.FType.BROADCAST)) {
            FederatedRequest fr2 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, fr1.getID());
            Future<FederatedResponse>[] tmp = mo1.getFedMapping().execute(this.getTID(), fr1, fr2);
            MatrixBlock[] outBlocks = FederationUtils.getResults(tmp);
            ec.setMatrixOutput(this.output.getName(), outBlocks[0]);
        } else {
            FederatedRequest fr2 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, fr1.getID());
            FederatedRequest fr3 = mo1.getFedMapping().cleanup(this.getTID(), fr1.getID());
            Future<FederatedResponse>[] tmp = mo1.getFedMapping().execute(this.getTID(), fr1, fr2, fr3);
            MatrixBlock ret = FederationUtils.aggAdd(tmp);
            ec.setMatrixOutput(this.output.getName(), ret);
        }
    }

    private void setOutputFederated(ExecutionContext ec, MatrixObject mo1, FederatedRequest fr1, FTypes.FType outFType) {
        MatrixObject out = ec.getMatrixObject(this.output);
        out.getDataCharacteristics().set(mo1.getNumColumns(), mo1.getNumColumns(), mo1.getBlocksize());
        FederationMap outputFedMap = mo1.getFedMapping().copyWithNewIDAndRange(mo1.getNumColumns(), mo1.getNumColumns(), fr1.getID(), outFType);
        out.setFedMapping(outputFedMap);
    }
}

