/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.parser.ParForStatementBlock;
import org.apache.sysds.runtime.controlprogram.LocalVariableMap;
import org.apache.sysds.runtime.controlprogram.ProgramBlock;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.parfor.ParForBody;
import org.apache.sysds.runtime.controlprogram.parfor.Task;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.IntObject;
import org.apache.sysds.runtime.lineage.Lineage;

public abstract class ParWorker {
    protected static final Log LOG = LogFactory.getLog((String)ParWorker.class.getName());
    protected long _workerID = -1L;
    protected ArrayList<ProgramBlock> _childBlocks = null;
    protected ExecutionContext _ec = null;
    protected ArrayList<ParForStatementBlock.ResultVar> _resultVars = null;
    protected long _numTasks = -1L;
    protected long _numIters = -1L;

    public ParWorker() {
    }

    public ParWorker(long ID, ParForBody body) {
        this._workerID = ID;
        if (body != null) {
            this._childBlocks = body.getChildBlocks();
            this._ec = body.getEc();
            this._resultVars = body.getResultVariables();
        }
        this._numTasks = 0L;
        this._numIters = 0L;
    }

    public ExecutionContext getExecutionContext() {
        return this._ec;
    }

    public LocalVariableMap getVariables() {
        return this._ec.getVariables();
    }

    public long getExecutedTasks() {
        return this._numTasks;
    }

    public long getExecutedIterations() {
        return this._numIters;
    }

    protected void pinResultVariables() {
        for (ParForStatementBlock.ResultVar var : this._resultVars) {
            Data dat = this._ec.getVariable(var._name);
            if (!(dat instanceof MatrixObject)) continue;
            ((MatrixObject)dat).enableCleanup(false);
        }
    }

    protected void executeTask(Task task) {
        LOG.trace((Object)("EXECUTE PARFOR_WORKER ID=" + this._workerID + " for task " + task.toCompactString()));
        switch (task.getType()) {
            case SET: {
                this.executeSetTask(task);
                break;
            }
            case RANGE: {
                this.executeRangeTask(task);
            }
        }
    }

    private void executeSetTask(Task task) {
        String lVarName = task.getVarName();
        for (IntObject indexVal : task.getIterations()) {
            this._ec.setVariable(lVarName, indexVal);
            if (DMLScript.LINEAGE) {
                Lineage li = this._ec.getLineage();
                li.set(lVarName, li.getOrCreate(new CPOperand(indexVal)));
            }
            for (ProgramBlock pb : this._childBlocks) {
                pb.execute(this._ec);
            }
            ++this._numIters;
        }
        ++this._numTasks;
    }

    private void executeRangeTask(Task task) {
        List<IntObject> tmp = task.getIterations();
        String lVarName = task.getVarName();
        long lFrom = tmp.get(0).getLongValue();
        long lTo = tmp.get(1).getLongValue();
        long lIncr = tmp.get(2).getLongValue();
        for (long i = lFrom; i <= lTo; i += lIncr) {
            IntObject indexVal = new IntObject(i);
            this._ec.setVariable(lVarName, indexVal);
            if (DMLScript.LINEAGE) {
                Lineage li = this._ec.getLineage();
                li.set(lVarName, li.getOrCreate(new CPOperand(indexVal)));
            }
            for (ProgramBlock pb : this._childBlocks) {
                pb.execute(this._ec);
            }
            ++this._numIters;
        }
        ++this._numTasks;
    }
}

