/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.info;

import io.smallrye.openapi.api.models.info.InfoImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.ModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.extensions.ExtensionIO;
import io.smallrye.openapi.runtime.io.info.ContactIO;
import io.smallrye.openapi.runtime.io.info.LicenseIO;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.info.License;
import org.jboss.jandex.AnnotationInstance;

public class InfoIO<V, A extends V, O extends V, AB, OB>
extends ModelIO<Info, V, A, O, AB, OB> {
    private static final String PROP_TERMS_OF_SERVICE = "termsOfService";
    private static final String PROP_TITLE = "title";
    private static final String PROP_VERSION = "version";
    private static final String PROP_DESCRIPTION = "description";
    private static final String PROP_LICENSE = "license";
    private static final String PROP_CONTACT = "contact";
    private final ContactIO<V, A, O, AB, OB> contact;
    private final LicenseIO<V, A, O, AB, OB> license;
    private final ExtensionIO<V, A, O, AB, OB> extensionIO;

    public InfoIO(IOContext<V, A, O, AB, OB> context, ExtensionIO<V, A, O, AB, OB> extensionIO) {
        super(context, Names.INFO, Names.create(Info.class));
        this.contact = new ContactIO<V, A, O, AB, OB>(context, extensionIO);
        this.license = new LicenseIO<V, A, O, AB, OB>(context, extensionIO);
        this.extensionIO = extensionIO;
    }

    @Override
    public Info read(AnnotationInstance annotation) {
        IoLogging.logger.annotation("@Info");
        InfoImpl info = new InfoImpl();
        info.setTitle((String)this.value(annotation, PROP_TITLE));
        info.setDescription((String)this.value(annotation, PROP_DESCRIPTION));
        info.setTermsOfService((String)this.value(annotation, PROP_TERMS_OF_SERVICE));
        info.setContact((Contact)this.contact.read(annotation.value(PROP_CONTACT)));
        info.setLicense((License)this.license.read(annotation.value(PROP_LICENSE)));
        info.setVersion((String)this.value(annotation, PROP_VERSION));
        info.setExtensions(this.extensionIO.readExtensible(annotation));
        return info;
    }

    @Override
    public Info readObject(O node) {
        IoLogging.logger.singleJsonNode("Info");
        InfoImpl info = new InfoImpl();
        info.setTitle(this.jsonIO().getString(node, PROP_TITLE));
        info.setDescription(this.jsonIO().getString(node, PROP_DESCRIPTION));
        info.setTermsOfService(this.jsonIO().getString(node, PROP_TERMS_OF_SERVICE));
        info.setContact((Contact)this.contact.readValue(this.jsonIO().getValue(node, PROP_CONTACT)));
        info.setLicense((License)this.license.readValue(this.jsonIO().getValue(node, PROP_LICENSE)));
        info.setVersion(this.jsonIO().getString(node, PROP_VERSION));
        info.setExtensions(this.extensionIO.readMap(node));
        return info;
    }

    @Override
    public Optional<O> write(Info model) {
        return this.optionalJsonObject(model).map(node -> {
            this.setIfPresent(node, PROP_TITLE, this.jsonIO().toJson(model.getTitle()));
            this.setIfPresent(node, PROP_DESCRIPTION, this.jsonIO().toJson(model.getDescription()));
            this.setIfPresent(node, PROP_TERMS_OF_SERVICE, this.jsonIO().toJson(model.getTermsOfService()));
            this.setIfPresent(node, PROP_CONTACT, this.contact.write(model.getContact()));
            this.setIfPresent(node, PROP_LICENSE, this.license.write(model.getLicense()));
            this.setIfPresent(node, PROP_VERSION, this.jsonIO().toJson(model.getVersion()));
            this.setAllIfPresent(node, this.extensionIO.write((Extensible<?>)model));
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

