/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.swizzle.stream;

import java.io.IOException;
import java.io.InputStream;
import org.tomitribe.swizzle.stream.PushbackInputStream;
import org.tomitribe.swizzle.stream.ScanBuffer;
import org.tomitribe.swizzle.stream.StreamUtils;

public class TruncateInputStream
extends PushbackInputStream {
    private final String endToken;
    private final ScanBuffer tokenBuffer;
    private StreamReadingStrategy strategy;
    private final StreamReadingStrategy flushingBuffer = new StreamReadingStrategy(){

        @Override
        public int _read() throws IOException {
            return TruncateInputStream.this.tokenBuffer.append(-1);
        }
    };
    private final StreamReadingStrategy lookingForToken = new StreamReadingStrategy(){

        @Override
        public int _read() throws IOException {
            int stream = TruncateInputStream.this.getDelegate().read();
            int buffer = TruncateInputStream.this.tokenBuffer.append(stream);
            if (TruncateInputStream.this.tokenBuffer.match()) {
                TruncateInputStream.this.strategy = TruncateInputStream.this.flushingBuffer;
                int i = buffer == -1 && stream != -1 ? TruncateInputStream.this.read() : buffer;
                return i;
            }
            int i = buffer == -1 && TruncateInputStream.this.tokenBuffer.hasData() ? this._read() : buffer;
            return i;
        }
    };

    public TruncateInputStream(InputStream in, String end) {
        this(in, end, false);
    }

    public TruncateInputStream(InputStream delegate, String end, boolean caseSensitive) {
        super(delegate);
        if (delegate == null) {
            throw new NullPointerException("delegate is null");
        }
        if (end == null) {
            throw new NullPointerException("end is null");
        }
        this.endToken = end;
        this.tokenBuffer = new ScanBuffer(end, caseSensitive);
        this.strategy = this.lookingForToken;
    }

    public String getEndToken() {
        return this.endToken;
    }

    @Override
    protected int getNextByte() throws IOException {
        return this.strategy._read();
    }

    @Override
    public byte[] getBuffer() {
        return StreamUtils.join(super.getBuffer(), this.tokenBuffer.getBuffer());
    }

    private static interface StreamReadingStrategy {
        public int _read() throws IOException;
    }
}

