/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.sys;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.sys.Openejb;
import org.apache.openejb.config.sys.Resources;
import org.apache.openejb.config.sys.SaxOpenejb;
import org.apache.openejb.config.sys.Tomee;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.JavaSecurityManagers;
import org.apache.openejb.util.SimpleJSonParser;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class JSonConfigReader {
    private static final String COMMENT_KEY = "__";

    private static Map map(Object rawMap) {
        return (Map)Map.class.cast(rawMap);
    }

    public static <T> T read(Class<T> clazz, InputStream is) throws OpenEJBException {
        if (Openejb.class.equals(clazz) || Tomee.class.equals(clazz)) {
            SaxOpenejb handler = JSonConfigReader.read(is, "openejb", Arrays.asList("System-Property", "Resource", "Container", "JndiProvider", "TransactionManager", "ConnectionManager", "ProxyFactory", "Connector", "Deployments", "Import", "Service", "SecurityService"), new SaxOpenejb());
            return clazz.cast(handler.getOpenejb());
        }
        if (Resources.class.equals(clazz)) {
            Resources resources = new Resources();
            Openejb openejb = JSonConfigReader.read(is, "openejb", Arrays.asList("Resource", "Container", "JndiProvider", "Connector", "Import", "Service"), new SaxOpenejb()).getOpenejb();
            resources.getContainer().addAll(openejb.getContainer());
            resources.getResource().addAll(openejb.getResource());
            resources.getService().addAll(openejb.getServices());
            resources.getConnector().addAll(openejb.getConnector());
            resources.getJndiProvider().addAll(openejb.getJndiProvider());
            return clazz.cast(resources);
        }
        throw new IllegalArgumentException(clazz.getName() + " not supported");
    }

    private static <T extends DefaultHandler> T read(InputStream is, String mainRoot, Collection<String> roots, T handler) throws OpenEJBException {
        try {
            handler.startDocument();
            handler.startElement(null, mainRoot, null, new AttributesImpl());
            Map jsConfig = JSonConfigReader.map(SimpleJSonParser.read(is));
            jsConfig.remove(COMMENT_KEY);
            for (String root : roots) {
                Object currentRoot = root.endsWith("s") ? root.toLowerCase(Locale.ENGLISH) : root.toLowerCase(Locale.ENGLISH) + "s";
                Map resources = JSonConfigReader.map(jsConfig.get(currentRoot));
                if (resources == null) continue;
                resources.remove(COMMENT_KEY);
                for (Map.Entry resource : resources.entrySet()) {
                    AttributesImpl attributes = JSonConfigReader.toAttributes(JSonConfigReader.map(resource.getValue()), "properties");
                    if (!"deployments".equals(currentRoot)) {
                        attributes.addAttribute(null, "id", "id", null, (String)resource.getKey());
                    }
                    if ("resources".equals(currentRoot) && attributes.getIndex("type") == -1 && attributes.getIndex("class-name") == -1 && attributes.getIndex("provider") == -1) {
                        attributes.addAttribute(null, "type", "type", null, "DataSource");
                    }
                    handler.startElement(null, root, root, attributes);
                    String propertiesAsStr = JSonConfigReader.toString(JSonConfigReader.map(((Map)resource.getValue()).get("properties")));
                    handler.characters(propertiesAsStr.toCharArray(), 0, propertiesAsStr.length());
                    handler.endElement(null, root, root);
                }
            }
            handler.endElement(null, mainRoot, null);
            if (jsConfig.containsKey("system-properties")) {
                Map sysProps = JSonConfigReader.map(jsConfig.get("system-properties"));
                JSonConfigReader.setProperties("", sysProps);
            }
            if (jsConfig.containsKey("daemons")) {
                Map daemons = JSonConfigReader.map(jsConfig.get("daemons"));
                for (Map.Entry entry : daemons.entrySet()) {
                    JSonConfigReader.setProperties((String)entry.getKey() + ".", JSonConfigReader.map(entry.getValue()));
                }
            }
        }
        catch (Exception e) {
            throw new OpenEJBException(e.getMessage(), e);
        }
        return handler;
    }

    private static void setProperties(String prefix, Map<?, ?> sysProps) {
        sysProps.remove(COMMENT_KEY);
        for (Map.Entry<?, ?> entry : sysProps.entrySet()) {
            String key = prefix + entry.getKey().toString();
            Object value = entry.getValue();
            if (String.class.isInstance(value)) {
                String str = (String)String.class.cast(value);
                SystemInstance.get().setProperty(key, str);
                JavaSecurityManagers.setSystemProperty(key, str);
                continue;
            }
            JSonConfigReader.setProperties(key + ".", JSonConfigReader.map(value));
        }
    }

    private static String toString(Map<String, ?> properties) {
        if (properties == null) {
            return "";
        }
        properties.remove(COMMENT_KEY);
        Properties builder = new Properties();
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            builder.put(entry.getKey(), entry.getValue().toString());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            builder.store(baos, "");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new String(baos.toByteArray());
    }

    private static AttributesImpl toAttributes(Map<String, String> map, String ... ignored) {
        map.remove(COMMENT_KEY);
        AttributesImpl attributes = new AttributesImpl();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            boolean add = true;
            for (String i : ignored) {
                if (!key.equals(i)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            attributes.addAttribute(null, key, key, null, entry.getValue());
        }
        return attributes;
    }
}

