/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.persistence;

import jakarta.batch.operations.NoSuchJobExecutionException;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobInstance;
import jakarta.batch.runtime.Metric;
import jakarta.batch.runtime.StepExecution;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.batchee.container.exception.BatchContainerServiceException;
import org.apache.batchee.container.exception.PersistenceException;
import org.apache.batchee.container.impl.JobExecutionImpl;
import org.apache.batchee.container.impl.JobInstanceImpl;
import org.apache.batchee.container.impl.StepContextImpl;
import org.apache.batchee.container.impl.StepExecutionImpl;
import org.apache.batchee.container.impl.controller.chunk.CheckpointData;
import org.apache.batchee.container.impl.controller.chunk.CheckpointDataKey;
import org.apache.batchee.container.impl.controller.chunk.PersistentDataWrapper;
import org.apache.batchee.container.impl.jobinstance.RuntimeFlowInSplitExecution;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.services.InternalJobExecution;
import org.apache.batchee.container.services.persistence.jdbc.Dictionary;
import org.apache.batchee.container.services.persistence.jdbc.database.Database;
import org.apache.batchee.container.services.persistence.jdbc.database.DerbyDatabase;
import org.apache.batchee.container.services.persistence.jpa.domain.PropertyHelper;
import org.apache.batchee.container.status.JobStatus;
import org.apache.batchee.container.status.StepStatus;
import org.apache.batchee.container.util.Serializations;
import org.apache.batchee.container.util.TCCLObjectInputStream;
import org.apache.batchee.spi.PersistenceManagerService;

public class JDBCPersistenceManagerService
implements PersistenceManagerService {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private Dictionary dictionary;
    protected DataSource dataSource = null;
    protected String jndiName = null;
    protected String driver = "";
    protected String schema = "";
    protected String url = "";
    protected String user = "";
    protected String pwd = "";

    @Override
    public void init(Properties batchConfig) throws BatchContainerServiceException {
        boolean hasSchema = "true".equalsIgnoreCase(batchConfig.getProperty("persistence.database.has-schema", "true"));
        this.schema = hasSchema ? batchConfig.getProperty("persistence.database.schema", "BATCHEE") : null;
        if (batchConfig.containsKey("persistence.database.jndi")) {
            this.jndiName = batchConfig.getProperty("persistence.database.jndi", "");
            if (this.jndiName.isEmpty()) {
                throw new BatchContainerServiceException("JNDI name is not defined.");
            }
            try {
                InitialContext ctx = new InitialContext();
                this.dataSource = (DataSource)DataSource.class.cast(ctx.lookup(this.jndiName));
            }
            catch (NamingException e) {
                throw new BatchContainerServiceException(e);
            }
        } else {
            this.driver = batchConfig.getProperty("persistence.database.driver", "org.apache.derby.jdbc.EmbeddedDriver");
            this.url = batchConfig.getProperty("persistence.database.url", "jdbc:derby:memory:batchee;create=true");
            this.user = batchConfig.getProperty("persistence.database.user", "app");
            this.pwd = batchConfig.getProperty("persistence.database.password", "app");
        }
        try {
            this.initDictionary(batchConfig);
            if ("create".equalsIgnoreCase(batchConfig.getProperty("persistence.database.ddl", "create"))) {
                if (hasSchema && !this.isSchemaValid()) {
                    this.createSchema();
                }
                this.checkAllTables();
            }
        }
        catch (SQLException e) {
            throw new BatchContainerServiceException(e);
        }
    }

    private void initDictionary(Properties batchConfig) throws BatchContainerServiceException, SQLException {
        String type = batchConfig.getProperty("persistence.database.db-dictionary", this.guessDictionary());
        if (type == null) {
            throw new IllegalArgumentException("You need to provide a db dictionary for this database");
        }
        try {
            Database database = (Database)Database.class.cast(Thread.currentThread().getContextClassLoader().loadClass(type).newInstance());
            this.dictionary = new Dictionary(batchConfig.getProperty("persistence.database.tables.checkpoint", "BATCH_CHECKPOINT"), batchConfig.getProperty("persistence.database.tables.job-instance", "BATCH_JOBINSTANCE"), batchConfig.getProperty("persistence.database.tables.job-execution", "BATCH_JOBEXECUTION"), batchConfig.getProperty("persistence.database.tables.step-execution", "BATCH_STEPEXECUTION"), database);
        }
        catch (Exception e) {
            throw new BatchContainerServiceException(e);
        }
    }

    private boolean isSchemaValid() throws SQLException {
        Connection conn = this.getConnectionToDefaultSchema();
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getSchemas();
        while (rs.next()) {
            if (!this.schema.equalsIgnoreCase(rs.getString("TABLE_SCHEM"))) continue;
            this.cleanupConnection(conn, rs, null);
            return true;
        }
        this.cleanupConnection(conn, rs, null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String guessDictionary() throws SQLException {
        String pn;
        try (Connection conn = this.getConnectionToDefaultSchema();){
            DatabaseMetaData dbmd = conn.getMetaData();
            pn = dbmd.getDatabaseProductName().toLowerCase();
        }
        if (pn.contains("derby")) {
            return DerbyDatabase.class.getName();
        }
        return null;
    }

    private void createSchema() throws SQLException {
        Connection conn = this.getConnectionToDefaultSchema();
        PreparedStatement ps = conn.prepareStatement("CREATE SCHEMA " + this.schema);
        ps.execute();
        this.cleanupConnection(conn, null, ps);
    }

    private void checkAllTables() throws SQLException {
        this.createIfNotExists(this.dictionary.getCheckpointTable(), this.dictionary.getCreateCheckpointTable());
        this.createIfNotExists(this.dictionary.getJobExecutionTable(), this.dictionary.getCreateJobExecutionTable());
        this.createIfNotExists(this.dictionary.getJobInstanceTable(), this.dictionary.getCreateJobInstanceTable());
        this.createIfNotExists(this.dictionary.getStepExecutionTable(), this.dictionary.getCreateStepExecutionTable());
    }

    protected Connection getConnection() throws SQLException {
        Connection connection;
        if (this.dataSource != null) {
            connection = this.dataSource.getConnection();
        } else {
            try {
                Class.forName(this.driver);
            }
            catch (ClassNotFoundException e) {
                throw new PersistenceException(e);
            }
            connection = DriverManager.getConnection(this.url, this.user, this.pwd);
        }
        this.setSchemaOnConnection(connection);
        return connection;
    }

    private void createIfNotExists(String tableName, String createTableStatement) throws SQLException {
        Connection conn = this.getConnection();
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getTables(null, this.schema, tableName, null);
        PreparedStatement ps = null;
        if (!rs.next()) {
            ps = conn.prepareStatement(createTableStatement);
            ps.executeUpdate();
        }
        this.cleanupConnection(conn, rs, ps);
    }

    public void createCheckpointData(CheckpointDataKey key, CheckpointData value) {
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getInsertCheckpoint());
            statement.setBytes(1, value.getRestartToken());
            statement.setString(2, key.getStepName());
            statement.setString(3, key.getType().name());
            statement.setLong(4, key.getJobInstanceId());
            statement.executeUpdate();
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            this.cleanupConnection(conn, null, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, null, statement);
                throw throwable;
            }
        }
    }

    @Override
    public CheckpointData getCheckpointData(CheckpointDataKey key) {
        return this.queryCheckpointData(key);
    }

    @Override
    public void setCheckpointData(CheckpointDataKey key, CheckpointData value) {
        if (this.queryCheckpointData(key) != null) {
            this.updateCheckpointData(key, value);
        } else {
            this.createCheckpointData(key, value);
        }
    }

    protected Connection getConnectionToDefaultSchema() throws SQLException {
        Connection connection;
        if (this.dataSource != null) {
            try {
                connection = this.dataSource.getConnection();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
        }
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            throw new PersistenceException(e);
        }
        try {
            connection = DriverManager.getConnection(this.url, this.user, this.pwd);
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        return connection;
    }

    private void setSchemaOnConnection(Connection connection) throws SQLException {
        if (this.schema == null) {
            return;
        }
        PreparedStatement ps = connection.prepareStatement("set schema ?");
        ps.setString(1, this.schema);
        ps.executeUpdate();
        ps.close();
    }

    private CheckpointData queryCheckpointData(CheckpointDataKey key) {
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block5: {
            conn = null;
            statement = null;
            rs = null;
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getSelectCheckpoint());
            statement.setLong(1, key.getJobInstanceId());
            statement.setString(2, key.getType().name());
            statement.setString(3, key.getStepName());
            rs = statement.executeQuery();
            if (!rs.next()) break block5;
            CheckpointData data = new CheckpointData(key.getJobInstanceId(), key.getStepName(), key.getType());
            data.setRestartToken(rs.getBytes(this.dictionary.checkpointColumn(1)));
            CheckpointData checkpointData = data;
            this.cleanupConnection(conn, rs, statement);
            return checkpointData;
        }
        try {
            CheckpointData data = null;
            this.cleanupConnection(conn, rs, statement);
            return data;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
    }

    private void updateCheckpointData(CheckpointDataKey key, CheckpointData value) {
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getUpdateCheckpoint());
            statement.setBytes(1, value.getRestartToken());
            statement.setLong(2, key.getJobInstanceId());
            statement.setString(3, key.getType().name());
            statement.setString(4, key.getStepName());
            statement.executeUpdate();
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            this.cleanupConnection(conn, null, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, null, statement);
                throw throwable;
            }
        }
    }

    private void cleanupConnection(Connection conn, ResultSet rs, PreparedStatement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
        }
        if (conn != null) {
            SQLException thrown = null;
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    thrown = e;
                }
            }
            if (thrown != null) {
                throw new PersistenceException(thrown);
            }
        }
    }

    @Override
    public int jobOperatorGetJobInstanceCount(String jobName) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getCountJobInstanceByName());
            statement.setString(1, jobName);
            rs = statement.executeQuery();
            rs.next();
            int n = rs.getInt("jobinstancecount");
            this.cleanupConnection(conn, rs, statement);
            return n;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
    }

    @Override
    public List<Long> jobOperatorGetJobInstanceIds(String jobName, int start, int count) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        ArrayList<Long> data = new ArrayList<Long>();
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getFindJobInstanceIdsByName());
            statement.setObject(1, jobName);
            rs = statement.executeQuery();
            while (rs.next()) {
                data.add(rs.getLong(this.dictionary.jobInstanceColumns(0)));
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        if (data.size() > 0) {
            try {
                return data.subList(start, start + count);
            }
            catch (IndexOutOfBoundsException oobEx) {
                return data.subList(start, data.size());
            }
        }
        return data;
    }

    @Override
    public Set<String> getJobNames() {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        HashSet<String> jobNames = new HashSet<String>();
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getFindJobNames());
            rs = statement.executeQuery();
            while (rs.next()) {
                jobNames.add(rs.getString(1));
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return jobNames;
    }

    @Override
    public Timestamp jobOperatorQueryJobExecutionTimestamp(long key, PersistenceManagerService.TimestampType timestampType) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        Timestamp createTimestamp = null;
        Timestamp endTimestamp = null;
        Timestamp updateTimestamp = null;
        Timestamp startTimestamp = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getFindJobExecutionTimestamps());
            statement.setLong(1, key);
            rs = statement.executeQuery();
            while (rs.next()) {
                createTimestamp = rs.getTimestamp(1);
                endTimestamp = rs.getTimestamp(2);
                updateTimestamp = rs.getTimestamp(3);
                startTimestamp = rs.getTimestamp(4);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        if (timestampType.equals((Object)PersistenceManagerService.TimestampType.CREATE)) {
            return createTimestamp;
        }
        if (timestampType.equals((Object)PersistenceManagerService.TimestampType.END)) {
            return endTimestamp;
        }
        if (timestampType.equals((Object)PersistenceManagerService.TimestampType.LAST_UPDATED)) {
            return updateTimestamp;
        }
        if (timestampType.equals((Object)PersistenceManagerService.TimestampType.STARTED)) {
            return startTimestamp;
        }
        throw new IllegalArgumentException("Unexpected enum value.");
    }

    @Override
    public String jobOperatorQueryJobExecutionBatchStatus(long key) {
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block5: {
            conn = null;
            statement = null;
            rs = null;
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getFindJobExecutionBatchStatus());
            statement.setLong(1, key);
            rs = statement.executeQuery();
            if (!rs.next()) break block5;
            String string = rs.getString(1);
            this.cleanupConnection(conn, rs, statement);
            return string;
        }
        try {
            String string = null;
            this.cleanupConnection(conn, rs, statement);
            return string;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
    }

    @Override
    public String jobOperatorQueryJobExecutionExitStatus(long key) {
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block5: {
            conn = null;
            statement = null;
            rs = null;
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getFindJobExecutionExitStatus());
            statement.setLong(1, key);
            rs = statement.executeQuery();
            if (!rs.next()) break block5;
            String string = rs.getString(1);
            this.cleanupConnection(conn, rs, statement);
            return string;
        }
        try {
            String string = null;
            this.cleanupConnection(conn, rs, statement);
            return string;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
    }

    @Override
    public Properties getParameters(long executionId) throws NoSuchJobExecutionException {
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block5: {
            conn = null;
            statement = null;
            rs = null;
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getFindJobExecutionJobProperties());
            statement.setLong(1, executionId);
            rs = statement.executeQuery();
            if (!rs.next()) break block5;
            byte[] buf = rs.getBytes(this.dictionary.jobExecutionColumns(5));
            Properties properties = PropertyHelper.stringToProperties(buf != null ? new String(buf) : null);
            this.cleanupConnection(conn, rs, statement);
            return properties;
        }
        try {
            try {
                throw new NoSuchJobExecutionException("Did not find table entry for executionID =" + executionId);
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
        }
        catch (Throwable throwable) {
            this.cleanupConnection(conn, rs, statement);
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<StepExecution> getStepExecutionsForJobExecution(long execid) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        ArrayList<StepExecution> data = new ArrayList<StepExecution>();
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getFinStepExecutionFromJobExecution());
            statement.setLong(1, execid);
            rs = statement.executeQuery();
            while (true) {
                if (!rs.next()) {
                    this.cleanupConnection(conn, rs, statement);
                    return data;
                }
                long jobexecid = rs.getLong(this.dictionary.stepExecutionColumns(18));
                long stepexecid = rs.getLong(this.dictionary.stepExecutionColumns(0));
                String stepname = rs.getString(this.dictionary.stepExecutionColumns(15));
                String batchstatus = rs.getString(this.dictionary.stepExecutionColumns(1));
                String exitstatus = rs.getString(this.dictionary.stepExecutionColumns(4));
                long readCount = rs.getLong(this.dictionary.stepExecutionColumns(10));
                long writeCount = rs.getLong(this.dictionary.stepExecutionColumns(16));
                long commitCount = rs.getLong(this.dictionary.stepExecutionColumns(2));
                long rollbackCount = rs.getLong(this.dictionary.stepExecutionColumns(12));
                long readSkipCount = rs.getLong(this.dictionary.stepExecutionColumns(11));
                long processSkipCount = rs.getLong(this.dictionary.stepExecutionColumns(9));
                long filterCount = rs.getLong(this.dictionary.stepExecutionColumns(5));
                long writeSkipCount = rs.getLong(this.dictionary.stepExecutionColumns(17));
                Timestamp startTS = rs.getTimestamp(this.dictionary.stepExecutionColumns(14));
                Timestamp endTS = rs.getTimestamp(this.dictionary.stepExecutionColumns(3));
                Serializable persistentData = null;
                byte[] pDataBytes = rs.getBytes(this.dictionary.stepExecutionColumns(8));
                if (pDataBytes != null) {
                    TCCLObjectInputStream objectIn = new TCCLObjectInputStream(new ByteArrayInputStream(pDataBytes));
                    persistentData = (Serializable)objectIn.readObject();
                }
                StepExecutionImpl stepEx = new StepExecutionImpl(jobexecid, stepexecid);
                stepEx.setBatchStatus(BatchStatus.valueOf((String)batchstatus));
                stepEx.setExitStatus(exitstatus);
                stepEx.setStepName(stepname);
                stepEx.setReadCount(readCount);
                stepEx.setWriteCount(writeCount);
                stepEx.setCommitCount(commitCount);
                stepEx.setRollbackCount(rollbackCount);
                stepEx.setReadSkipCount(readSkipCount);
                stepEx.setProcessSkipCount(processSkipCount);
                stepEx.setFilterCount(filterCount);
                stepEx.setWriteSkipCount(writeSkipCount);
                stepEx.setStartTime(startTS);
                stepEx.setEndTime(endTS);
                stepEx.setPersistentUserData(persistentData);
                data.add(stepEx);
            }
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
                catch (ClassNotFoundException e3) {
                    throw new PersistenceException(e3);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StepExecution getStepExecutionByStepExecutionId(long stepExecId) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getFindStepExecutionFromId());
            statement.setLong(1, stepExecId);
            rs = statement.executeQuery();
            if (rs.next()) {
                long jobexecid = rs.getLong(this.dictionary.stepExecutionColumns(18));
                long stepExecutionId = rs.getLong(this.dictionary.stepExecutionColumns(0));
                String stepName = rs.getString(this.dictionary.stepExecutionColumns(15));
                String batchstatus = rs.getString(this.dictionary.stepExecutionColumns(1));
                String exitstatus = rs.getString(this.dictionary.stepExecutionColumns(4));
                long readCount = rs.getLong(this.dictionary.stepExecutionColumns(10));
                long writeCount = rs.getLong(this.dictionary.stepExecutionColumns(16));
                long commitCount = rs.getLong(this.dictionary.stepExecutionColumns(2));
                long rollbackCount = rs.getLong(this.dictionary.stepExecutionColumns(12));
                long readSkipCount = rs.getLong(this.dictionary.stepExecutionColumns(11));
                long processSkipCount = rs.getLong(this.dictionary.stepExecutionColumns(9));
                long filterCount = rs.getLong(this.dictionary.stepExecutionColumns(5));
                long writeSkipCount = rs.getLong(this.dictionary.stepExecutionColumns(17));
                Timestamp startTS = rs.getTimestamp(this.dictionary.stepExecutionColumns(14));
                Timestamp endTS = rs.getTimestamp(this.dictionary.stepExecutionColumns(3));
                Serializable persistentData = null;
                byte[] pDataBytes = rs.getBytes(this.dictionary.stepExecutionColumns(8));
                if (pDataBytes != null) {
                    persistentData = (Serializable)Serializable.class.cast(new TCCLObjectInputStream(new ByteArrayInputStream(pDataBytes)).readObject());
                }
                StepExecutionImpl stepEx = new StepExecutionImpl(jobexecid, stepExecutionId);
                stepEx.setBatchStatus(BatchStatus.valueOf((String)batchstatus));
                stepEx.setExitStatus(exitstatus);
                stepEx.setStepName(stepName);
                stepEx.setReadCount(readCount);
                stepEx.setWriteCount(writeCount);
                stepEx.setCommitCount(commitCount);
                stepEx.setRollbackCount(rollbackCount);
                stepEx.setReadSkipCount(readSkipCount);
                stepEx.setProcessSkipCount(processSkipCount);
                stepEx.setFilterCount(filterCount);
                stepEx.setWriteSkipCount(writeSkipCount);
                stepEx.setStartTime(startTS);
                stepEx.setEndTime(endTS);
                stepEx.setPersistentUserData(persistentData);
                StepExecutionImpl stepExecutionImpl = stepEx;
                this.cleanupConnection(conn, rs, statement);
                return stepExecutionImpl;
            }
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
                catch (ClassNotFoundException e3) {
                    throw new PersistenceException(e3);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        {
            StepExecution jobexecid = null;
            this.cleanupConnection(conn, rs, statement);
            return jobexecid;
        }
    }

    @Override
    public void updateBatchStatusOnly(long key, BatchStatus batchStatus, Timestamp updatets) {
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getUpdateJobExecution());
            statement.setString(1, batchStatus.name());
            statement.setTimestamp(2, updatets);
            statement.setLong(3, key);
            statement.executeUpdate();
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            this.cleanupConnection(conn, null, statement);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, null, statement);
                throw throwable;
            }
        }
    }

    @Override
    public void updateWithFinalExecutionStatusesAndTimestamps(long key, BatchStatus batchStatus, String exitStatus, Timestamp updatets) {
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getSetJobExecutionFinalData());
            statement.setString(1, batchStatus.name());
            statement.setString(2, exitStatus);
            statement.setTimestamp(3, updatets);
            statement.setTimestamp(4, updatets);
            statement.setLong(5, key);
            statement.executeUpdate();
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            this.cleanupConnection(conn, null, statement);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, null, statement);
                throw throwable;
            }
        }
    }

    @Override
    public void markJobStarted(long key, Timestamp startTS) {
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getUpdateStartedJobExecution());
            statement.setString(1, BatchStatus.STARTED.name());
            statement.setTimestamp(2, startTS);
            statement.setTimestamp(3, startTS);
            statement.setLong(4, key);
            statement.executeUpdate();
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            this.cleanupConnection(conn, null, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, null, statement);
                throw throwable;
            }
        }
    }

    @Override
    public InternalJobExecution jobOperatorGetJobExecution(long jobExecutionId) {
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block5: {
            conn = null;
            statement = null;
            rs = null;
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getFindJobExecutionById());
            statement.setLong(1, jobExecutionId);
            rs = statement.executeQuery();
            if (!rs.next()) break block5;
            Timestamp createtime = rs.getTimestamp(this.dictionary.jobExecutionColumns(2));
            Timestamp starttime = rs.getTimestamp(this.dictionary.jobExecutionColumns(6));
            Timestamp endtime = rs.getTimestamp(this.dictionary.jobExecutionColumns(3));
            Timestamp updatetime = rs.getTimestamp(this.dictionary.jobExecutionColumns(7));
            long instanceId = rs.getLong(this.dictionary.jobExecutionColumns(8));
            String batchStatus = rs.getString(this.dictionary.jobExecutionColumns(1));
            String exitStatus = rs.getString(this.dictionary.jobExecutionColumns(4));
            byte[] buf = rs.getBytes(this.dictionary.jobExecutionColumns(5));
            Properties params = (Properties)Properties.class.cast(PropertyHelper.stringToProperties(buf != null ? new String(buf) : null));
            String jobName = rs.getString(this.dictionary.jobInstanceColumns(3));
            JobExecutionImpl jobEx = new JobExecutionImpl(jobExecutionId, instanceId, this);
            jobEx.setCreateTime(createtime);
            jobEx.setStartTime(starttime);
            jobEx.setEndTime(endtime);
            jobEx.setJobParameters(params);
            jobEx.setLastUpdateTime(updatetime);
            jobEx.setBatchStatus(batchStatus);
            jobEx.setExitStatus(exitStatus);
            jobEx.setJobName(jobName);
            JobExecutionImpl jobExecutionImpl = jobEx;
            this.cleanupConnection(conn, rs, statement);
            return jobExecutionImpl;
        }
        try {
            InternalJobExecution createtime = null;
            this.cleanupConnection(conn, rs, statement);
            return createtime;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
    }

    @Override
    public List<InternalJobExecution> jobOperatorGetJobExecutions(long jobInstanceId) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        ArrayList<InternalJobExecution> data = new ArrayList<InternalJobExecution>();
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getFindJobExecutionByInstance());
            statement.setLong(1, jobInstanceId);
            rs = statement.executeQuery();
            while (rs.next()) {
                long jobExecutionId = rs.getLong(this.dictionary.jobExecutionColumns(0));
                Timestamp createtime = rs.getTimestamp(this.dictionary.jobExecutionColumns(2));
                Timestamp starttime = rs.getTimestamp(this.dictionary.jobExecutionColumns(6));
                Timestamp endtime = rs.getTimestamp(this.dictionary.jobExecutionColumns(3));
                Timestamp updatetime = rs.getTimestamp(this.dictionary.jobExecutionColumns(7));
                String batchStatus = rs.getString(this.dictionary.jobExecutionColumns(1));
                String exitStatus = rs.getString(this.dictionary.jobExecutionColumns(4));
                String jobName = rs.getString(this.dictionary.jobInstanceColumns(3));
                byte[] buf = rs.getBytes(this.dictionary.jobExecutionColumns(5));
                Properties params = buf != null ? PropertyHelper.stringToProperties(new String(buf)) : null;
                JobExecutionImpl jobEx = new JobExecutionImpl(jobExecutionId, jobInstanceId, this);
                jobEx.setCreateTime(createtime);
                jobEx.setStartTime(starttime);
                jobEx.setEndTime(endtime);
                jobEx.setLastUpdateTime(updatetime);
                jobEx.setBatchStatus(batchStatus);
                jobEx.setExitStatus(exitStatus);
                jobEx.setJobName(jobName);
                jobEx.setJobParameters(params);
                data.add(jobEx);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return data;
    }

    @Override
    public Set<Long> jobOperatorGetRunningExecutions(String jobName) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        HashSet<Long> executionIds = new HashSet<Long>();
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getFindRunningJobExecutions());
            statement.setString(1, BatchStatus.STARTED.name());
            statement.setString(2, BatchStatus.STARTING.name());
            statement.setString(3, BatchStatus.STOPPING.name());
            statement.setString(4, jobName);
            rs = statement.executeQuery();
            while (rs.next()) {
                executionIds.add(rs.getLong(this.dictionary.jobExecutionColumns(0)));
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return executionIds;
    }

    @Override
    public JobStatus getJobStatusFromExecution(long executionId) {
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block6: {
            conn = null;
            statement = null;
            rs = null;
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getFindJobStatus());
            statement.setLong(1, executionId);
            rs = statement.executeQuery();
            if (!rs.next()) break block6;
            long jobInstanceId = rs.getLong(this.dictionary.jobExecutionColumns(8));
            String batchStatus = rs.getString(this.dictionary.jobExecutionColumns(1));
            byte[] jobXmls = rs.getBytes(this.dictionary.jobInstanceColumns(4));
            JobInstanceImpl jobInstance = jobXmls != null ? new JobInstanceImpl(jobInstanceId, new String(jobXmls, UTF_8)) : new JobInstanceImpl(jobInstanceId);
            jobInstance.setJobName(rs.getString(this.dictionary.jobInstanceColumns(3)));
            JobStatus status = new JobStatus(jobInstanceId);
            status.setExitStatus(rs.getString(this.dictionary.jobInstanceColumns(2)));
            status.setLatestExecutionId(rs.getLong(this.dictionary.jobInstanceColumns(5)));
            status.setRestartOn(rs.getString(this.dictionary.jobInstanceColumns(6)));
            status.setCurrentStepId(rs.getString(this.dictionary.jobInstanceColumns(7)));
            status.setJobInstance(jobInstance);
            if (batchStatus != null) {
                status.setBatchStatus(BatchStatus.valueOf((String)batchStatus));
            }
            JobStatus jobStatus = status;
            this.cleanupConnection(conn, rs, statement);
            return jobStatus;
        }
        try {
            JobStatus jobInstanceId = null;
            this.cleanupConnection(conn, rs, statement);
            return jobInstanceId;
        }
        catch (Exception e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
    }

    @Override
    public long getJobInstanceIdByExecutionId(long executionId) throws NoSuchJobExecutionException {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getFindJobInstanceFromJobExecution());
            statement.setObject(1, executionId);
            rs = statement.executeQuery();
            if (!rs.next()) {
                throw new NoSuchJobExecutionException("Did not find job instance associated with executionID =" + executionId);
            }
            long l = rs.getLong(this.dictionary.jobExecutionColumns(8));
            this.cleanupConnection(conn, rs, statement);
            return l;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
    }

    @Override
    public JobInstance createSubJobInstance(String name) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        JobInstanceImpl jobInstance = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getCreateJobInstance(), 1);
            statement.setString(1, name);
            statement.executeUpdate();
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            if ((rs = statement.getGeneratedKeys()).next()) {
                long jobInstanceID = rs.getLong(1);
                jobInstance = new JobInstanceImpl(jobInstanceID);
                jobInstance.setJobName(name);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return jobInstance;
    }

    @Override
    public JobInstance createJobInstance(String name, String jobXml) {
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block6: {
            conn = null;
            statement = null;
            rs = null;
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getCreateJobInstanceWithJobXml(), 1);
            statement.setString(1, name);
            statement.setBytes(2, jobXml.getBytes(UTF_8));
            statement.executeUpdate();
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            if (!(rs = statement.getGeneratedKeys()).next()) break block6;
            long jobInstanceID = rs.getLong(1);
            JobInstanceImpl jobInstance = new JobInstanceImpl(jobInstanceID, jobXml);
            jobInstance.setJobName(name);
            JobInstanceImpl jobInstanceImpl = jobInstance;
            this.cleanupConnection(conn, rs, statement);
            return jobInstanceImpl;
        }
        try {
            JobInstance jobInstanceID = null;
            this.cleanupConnection(conn, rs, statement);
            return jobInstanceID;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
    }

    @Override
    public RuntimeJobExecution createJobExecution(JobInstance jobInstance, Properties jobParameters, BatchStatus batchStatus) {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        long newExecutionId = this.createRuntimeJobExecutionEntry(jobInstance, jobParameters, batchStatus, now);
        RuntimeJobExecution jobExecution = new RuntimeJobExecution(jobInstance, newExecutionId, this);
        jobExecution.setBatchStatus(batchStatus.name());
        jobExecution.setCreateTime(now);
        jobExecution.setLastUpdateTime(now);
        return jobExecution;
    }

    private long createRuntimeJobExecutionEntry(JobInstance jobInstance, Properties jobParameters, BatchStatus batchStatus, Timestamp timestamp) {
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block6: {
            conn = null;
            statement = null;
            rs = null;
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getCreateJobExecution(), 1);
            statement.setLong(1, jobInstance.getInstanceId());
            statement.setTimestamp(2, timestamp);
            statement.setTimestamp(3, timestamp);
            statement.setString(4, batchStatus.name());
            String propVal = PropertyHelper.propertiesToString(jobParameters);
            statement.setObject(5, propVal != null ? propVal.getBytes() : null);
            statement.executeUpdate();
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            if (!(rs = statement.getGeneratedKeys()).next()) break block6;
            long l = rs.getLong(1);
            this.cleanupConnection(conn, rs, statement);
            return l;
        }
        try {
            long l = -1L;
            this.cleanupConnection(conn, rs, statement);
            return l;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
    }

    @Override
    public RuntimeFlowInSplitExecution createFlowInSplitExecution(JobInstance jobInstance, BatchStatus batchStatus) {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        long newExecutionId = this.createRuntimeJobExecutionEntry(jobInstance, null, batchStatus, now);
        RuntimeFlowInSplitExecution flowExecution = new RuntimeFlowInSplitExecution(jobInstance, newExecutionId, this);
        flowExecution.setBatchStatus(batchStatus.name());
        flowExecution.setCreateTime(now);
        flowExecution.setLastUpdateTime(now);
        return flowExecution;
    }

    @Override
    public StepExecutionImpl createStepExecution(long rootJobExecId, StepContextImpl stepContext) {
        Metric[] metrics;
        String batchStatus = stepContext.getBatchStatus() == null ? BatchStatus.STARTING.name() : stepContext.getBatchStatus().name();
        String exitStatus = stepContext.getExitStatus();
        String stepName = stepContext.getStepName();
        long readCount = 0L;
        long writeCount = 0L;
        long commitCount = 0L;
        long rollbackCount = 0L;
        long readSkipCount = 0L;
        long processSkipCount = 0L;
        long filterCount = 0L;
        long writeSkipCount = 0L;
        Timestamp startTime = stepContext.getStartTimeTS();
        Timestamp endTime = stepContext.getEndTimeTS();
        for (Metric metric : metrics = stepContext.getMetrics()) {
            if (metric.getType().equals((Object)Metric.MetricType.READ_COUNT)) {
                readCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.WRITE_COUNT)) {
                writeCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.PROCESS_SKIP_COUNT)) {
                processSkipCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.COMMIT_COUNT)) {
                commitCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.ROLLBACK_COUNT)) {
                rollbackCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.READ_SKIP_COUNT)) {
                readSkipCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.FILTER_COUNT)) {
                filterCount = metric.getValue();
                continue;
            }
            if (!metric.getType().equals((Object)Metric.MetricType.WRITE_SKIP_COUNT)) continue;
            writeSkipCount = metric.getValue();
        }
        Serializable persistentData = stepContext.getPersistentUserData();
        return this.createStepExecution(rootJobExecId, batchStatus, exitStatus, stepName, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount, startTime, endTime, persistentData);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StepExecutionImpl createStepExecution(long rootJobExecId, String batchStatus, String exitStatus, String stepName, long readCount, long writeCount, long commitCount, long rollbackCount, long readSkipCount, long processSkipCount, long filterCount, long writeSkipCount, Timestamp startTime, Timestamp endTime, Serializable persistentData) {
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            ResultSet rs;
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getCreateStepExecution(), 1);
            statement.setLong(1, rootJobExecId);
            statement.setString(2, batchStatus);
            statement.setString(3, exitStatus);
            statement.setString(4, stepName);
            statement.setLong(5, readCount);
            statement.setLong(6, writeCount);
            statement.setLong(7, commitCount);
            statement.setLong(8, rollbackCount);
            statement.setLong(9, readSkipCount);
            statement.setLong(10, processSkipCount);
            statement.setLong(11, filterCount);
            statement.setLong(12, writeSkipCount);
            statement.setTimestamp(13, startTime);
            statement.setTimestamp(14, endTime);
            statement.setObject(15, Serializations.serialize(persistentData));
            statement.executeUpdate();
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            if ((rs = statement.getGeneratedKeys()).next()) {
                long stepExecutionId = rs.getLong(1);
                StepExecutionImpl stepExecution = new StepExecutionImpl(rootJobExecId, stepExecutionId);
                stepExecution.setStepName(stepName);
                StepExecutionImpl stepExecutionImpl = stepExecution;
                this.cleanupConnection(conn, null, statement);
                return stepExecutionImpl;
            }
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, null, statement);
                throw throwable;
            }
        }
        {
            StepExecutionImpl stepExecutionId = null;
            this.cleanupConnection(conn, null, statement);
            return stepExecutionId;
        }
    }

    @Override
    public void updateStepExecution(long rootJobExecId, StepContextImpl stepContext) {
        Metric[] metrics;
        long stepExecutionId = stepContext.getStepInternalExecID();
        String batchStatus = stepContext.getBatchStatus() == null ? BatchStatus.STARTING.name() : stepContext.getBatchStatus().name();
        String exitStatus = stepContext.getExitStatus();
        String stepName = stepContext.getStepName();
        Timestamp startTime = stepContext.getStartTimeTS();
        Timestamp endTime = stepContext.getEndTimeTS();
        long readCount = 0L;
        long writeCount = 0L;
        long commitCount = 0L;
        long rollbackCount = 0L;
        long readSkipCount = 0L;
        long processSkipCount = 0L;
        long filterCount = 0L;
        long writeSkipCount = 0L;
        for (Metric metric : metrics = stepContext.getMetrics()) {
            if (metric.getType().equals((Object)Metric.MetricType.READ_COUNT)) {
                readCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.WRITE_COUNT)) {
                writeCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.PROCESS_SKIP_COUNT)) {
                processSkipCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.COMMIT_COUNT)) {
                commitCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.ROLLBACK_COUNT)) {
                rollbackCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.READ_SKIP_COUNT)) {
                readSkipCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.FILTER_COUNT)) {
                filterCount = metric.getValue();
                continue;
            }
            if (!metric.getType().equals((Object)Metric.MetricType.WRITE_SKIP_COUNT)) continue;
            writeSkipCount = metric.getValue();
        }
        Serializable persistentData = stepContext.getPersistentUserData();
        this.updateStepExecution(stepExecutionId, rootJobExecId, batchStatus, exitStatus, stepName, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount, startTime, endTime, persistentData);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateStepExecution(long stepExecutionId, long jobExecId, String batchStatus, String exitStatus, String stepName, long readCount, long writeCount, long commitCount, long rollbackCount, long readSkipCount, long processSkipCount, long filterCount, long writeSkipCount, Timestamp startTime, Timestamp endTime, Serializable persistentData) {
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getUpdateStepExecution());
            statement.setLong(1, jobExecId);
            statement.setString(2, batchStatus);
            statement.setString(3, exitStatus);
            statement.setString(4, stepName);
            statement.setLong(5, readCount);
            statement.setLong(6, writeCount);
            statement.setLong(7, commitCount);
            statement.setLong(8, rollbackCount);
            statement.setLong(9, readSkipCount);
            statement.setLong(10, processSkipCount);
            statement.setLong(11, filterCount);
            statement.setLong(12, writeSkipCount);
            statement.setTimestamp(13, startTime);
            statement.setTimestamp(14, endTime);
            statement.setObject(15, Serializations.serialize(persistentData));
            statement.setLong(16, stepExecutionId);
            statement.executeUpdate();
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            this.cleanupConnection(conn, null, statement);
            return;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, null, statement);
                throw throwable;
            }
        }
    }

    @Override
    public JobStatus createJobStatus(long jobInstanceId) {
        return new JobStatus(jobInstanceId);
    }

    @Override
    public JobStatus getJobStatus(long instanceId) {
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block6: {
            conn = null;
            statement = null;
            rs = null;
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getFindJobInstance());
            statement.setLong(1, instanceId);
            rs = statement.executeQuery();
            if (!rs.next()) break block6;
            JobStatus status = new JobStatus(instanceId);
            status.setCurrentStepId(this.dictionary.jobExecutionColumns(7));
            status.setExitStatus(this.dictionary.jobExecutionColumns(2));
            byte[] jobXmls = rs.getBytes(this.dictionary.jobInstanceColumns(4));
            JobInstanceImpl instance = jobXmls != null ? new JobInstanceImpl(instanceId, new String(jobXmls, UTF_8)) : new JobInstanceImpl(instanceId);
            instance.setJobName(rs.getString(this.dictionary.jobInstanceColumns(3)));
            status.setJobInstance(instance);
            status.setLatestExecutionId(rs.getLong(this.dictionary.jobInstanceColumns(5)));
            status.setRestartOn(rs.getString(this.dictionary.jobInstanceColumns(6)));
            String batchStatus = rs.getString(this.dictionary.stepExecutionColumns(1));
            if (batchStatus != null) {
                status.setBatchStatus(BatchStatus.valueOf((String)batchStatus));
            }
            JobStatus jobStatus = status;
            this.cleanupConnection(conn, rs, statement);
            return jobStatus;
        }
        try {
            JobStatus status = null;
            this.cleanupConnection(conn, rs, statement);
            return status;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
    }

    @Override
    public void updateJobStatus(long instanceId, JobStatus jobStatus) {
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getUpdateJobInstanceStatus());
            if (jobStatus.getBatchStatus() != null) {
                statement.setString(1, jobStatus.getBatchStatus().name());
            } else {
                statement.setString(1, null);
            }
            statement.setString(2, jobStatus.getExitStatus());
            statement.setLong(3, jobStatus.getLatestExecutionId());
            statement.setString(4, jobStatus.getRestartOn());
            statement.setString(5, jobStatus.getCurrentStepId());
            if (jobStatus.getJobInstance() != null) {
                statement.setString(6, jobStatus.getJobInstance().getJobName());
            } else {
                statement.setString(6, null);
            }
            statement.setLong(7, instanceId);
            statement.executeUpdate();
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            this.cleanupConnection(conn, null, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, null, statement);
                throw throwable;
            }
        }
    }

    @Override
    public StepStatus createStepStatus(long stepExecId) {
        return new StepStatus(stepExecId);
    }

    @Override
    public StepStatus getStepStatus(long instanceId, String stepName) {
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block7: {
            conn = null;
            statement = null;
            rs = null;
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getFindStepExecutionByJobInstanceAndStepName());
            statement.setLong(1, instanceId);
            statement.setString(2, stepName);
            rs = statement.executeQuery();
            if (!rs.next()) break block7;
            int startCount = rs.getInt(this.dictionary.stepExecutionColumns(13));
            long id = rs.getLong(this.dictionary.stepExecutionColumns(0));
            StepStatus stepStatus = new StepStatus(id, startCount);
            int numPartitions = rs.getInt(this.dictionary.stepExecutionColumns(7));
            byte[] persistentDatas = rs.getBytes(this.dictionary.stepExecutionColumns(8));
            if (numPartitions >= 0) {
                stepStatus.setNumPartitions(numPartitions);
            }
            if (persistentDatas != null) {
                stepStatus.setPersistentUserData(new PersistentDataWrapper(persistentDatas));
            }
            stepStatus.setBatchStatus(BatchStatus.valueOf((String)rs.getString(this.dictionary.stepExecutionColumns(1))));
            stepStatus.setExitStatus(rs.getString(this.dictionary.stepExecutionColumns(4)));
            stepStatus.setLastRunStepExecutionId(rs.getLong(this.dictionary.stepExecutionColumns(6)));
            stepStatus.setStepExecutionId(id);
            StepStatus stepStatus2 = stepStatus;
            this.cleanupConnection(conn, rs, statement);
            return stepStatus2;
        }
        try {
            StepStatus startCount = null;
            this.cleanupConnection(conn, rs, statement);
            return startCount;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
    }

    @Override
    public void updateStepStatus(long stepExecutionId, StepStatus stepStatus) {
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getUpdateStepExecutionStatus());
            statement.setBytes(1, stepStatus.getRawPersistentUserData());
            if (stepStatus.getBatchStatus() != null) {
                statement.setString(2, stepStatus.getBatchStatus().name());
            } else {
                statement.setString(2, null);
            }
            statement.setString(3, stepStatus.getExitStatus());
            statement.setLong(4, stepStatus.getLastRunStepExecutionId());
            if (stepStatus.getNumPartitions() != null) {
                statement.setInt(5, stepStatus.getNumPartitions());
            } else {
                statement.setInt(5, -1);
            }
            statement.setInt(6, stepStatus.getStartCount());
            statement.setLong(7, stepStatus.getStepExecutionId());
            statement.executeUpdate();
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            this.cleanupConnection(conn, null, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, null, statement);
                throw throwable;
            }
        }
    }

    @Override
    public long getMostRecentExecutionId(long jobInstanceId) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(this.dictionary.getFindMostRecentJobExecution());
            statement.setLong(1, jobInstanceId);
            rs = statement.executeQuery();
            if (rs.next()) {
                long l = rs.getLong(1);
                this.cleanupConnection(conn, rs, statement);
                return l;
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return -1L;
    }

    @Override
    public void cleanUp(long instanceId) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            JDBCPersistenceManagerService.deleteFromInstanceId(instanceId, conn, this.dictionary.getDeleteStepExecution());
            JDBCPersistenceManagerService.deleteFromInstanceId(instanceId, conn, this.dictionary.getDeleteCheckpoint());
            JDBCPersistenceManagerService.deleteFromInstanceId(instanceId, conn, this.dictionary.getDeleteJobExecution());
            JDBCPersistenceManagerService.deleteFromInstanceId(instanceId, conn, this.dictionary.getDeleteJobInstance());
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        finally {
            this.cleanupConnection(conn, null, null);
        }
    }

    @Override
    public void cleanUp(Date until) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            JDBCPersistenceManagerService.deleteUntil(until, conn, this.dictionary.getDeleteStepExecutionUntil());
            JDBCPersistenceManagerService.deleteUntil(until, conn, this.dictionary.getDeleteCheckpointUntil());
            JDBCPersistenceManagerService.deleteUntil(until, conn, this.dictionary.getDeleteJobInstanceUntil());
            JDBCPersistenceManagerService.deleteUntil(until, conn, this.dictionary.getDeleteJobExecutionUntil());
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        finally {
            this.cleanupConnection(conn, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteUntil(Date until, Connection conn, String delete) throws SQLException {
        try (PreparedStatement statement = null;){
            statement = conn.prepareStatement(delete);
            statement.setTimestamp(1, new Timestamp(until.getTime()));
            statement.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteFromInstanceId(long instanceId, Connection conn, String delete) throws SQLException {
        try (PreparedStatement statement = null;){
            statement = conn.prepareStatement(delete);
            statement.setLong(1, instanceId);
            statement.executeUpdate();
        }
    }

    public String toString() {
        try {
            return "JDBCPersistenceManager{dictionary=" + this.dictionary + ", dataSource=" + this.dataSource + ", jndiName='" + this.jndiName + "', driver='" + this.driver + "', schema='" + this.schema + "', url='" + this.url + "', user='" + this.user + "', pwd='" + this.pwd + "'}";
        }
        catch (Throwable th) {
            return "JDBCPersistenceManager{dictionary=" + this.dictionary + "}";
        }
    }

    static interface Defaults {
        public static final String JDBC_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
        public static final String JDBC_URL = "jdbc:derby:memory:batchee;create=true";
        public static final String JDBC_USER = "app";
        public static final String JDBC_PASSWORD = "app";
        public static final String SCHEMA = "BATCHEE";
    }
}

