/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.model.XmlField;
import org.apache.fulcrum.intake.validator.FloatValidator;

public class FloatField
extends Field<Float> {
    private static final long serialVersionUID = -8878247008849251720L;

    public FloatField(XmlField field, Group group) throws IntakeException {
        super(field, group);
    }

    @Override
    public void setDefaultValue(String prop) {
        this.defaultValue = null;
        if (prop == null) {
            return;
        }
        this.defaultValue = new Float(prop);
    }

    @Override
    public void setEmptyValue(String prop) {
        this.emptyValue = null;
        if (prop == null) {
            return;
        }
        this.emptyValue = new Float(prop);
    }

    @Override
    protected Object getSafeEmptyValue() {
        if (this.isMultiValued) {
            return new float[0];
        }
        return null == this.getEmptyValue() ? new Float(0.0) : (Float)this.getEmptyValue();
    }

    @Override
    protected String getDefaultValidator() {
        return FloatValidator.class.getName();
    }

    @Override
    protected void doSetValue() {
        if (this.isMultiValued) {
            Float[] inputs = this.parser.getFloatObjects(this.getKey());
            float[] values = new float[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                values[i] = inputs[i] == null ? ((Float)this.getEmptyValue()).floatValue() : inputs[i].floatValue();
            }
            this.setTestValue(values);
        } else {
            this.setTestValue(this.parser.getFloatObject(this.getKey(), (Float)this.getEmptyValue()));
        }
    }
}

