/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.screens;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.annotation.TurbineLoader;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.modules.Screen;
import org.apache.turbine.modules.ScreenLoader;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.template.TemplateService;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.template.TemplateInfo;

public abstract class TemplateScreen
implements Screen {
    protected Logger log = LogManager.getLogger(this.getClass());
    @TurbineService
    private TemplateService templateService;
    @TurbineLoader(value=Screen.class)
    private ScreenLoader screenLoader;

    protected abstract void doBuildTemplate(PipelineData var1) throws Exception;

    public abstract String buildTemplate(PipelineData var1) throws Exception;

    protected void doPostBuildTemplate(PipelineData pipelineData) {
    }

    @Override
    public String doBuild(PipelineData pipelineData) throws Exception {
        String out = null;
        try {
            this.doBuildTemplate(pipelineData);
            out = this.buildTemplate(pipelineData);
        }
        finally {
            this.doPostBuildTemplate(pipelineData);
        }
        return out;
    }

    public static void setTemplate(PipelineData pipelineData, String template) {
        RunData data = (RunData)pipelineData;
        TemplateInfo ti = data.getTemplateInfo();
        TemplateService templateService = (TemplateService)TurbineServices.getInstance().getService("TemplateService");
        ti.setScreenTemplate(template);
        try {
            ti.setLayoutTemplate(templateService.getLayoutTemplateName(ti.getScreenTemplate()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doRedirect(PipelineData pipelineData, String screen, String template) throws Exception {
        this.log.debug("doRedirect(data, {}, {})", (Object)screen, (Object)template);
        TemplateScreen.setTemplate(pipelineData, template);
        this.screenLoader.exec(pipelineData, screen);
    }

    public void doRedirect(PipelineData pipelineData, String template) throws Exception {
        this.doRedirect(pipelineData, this.templateService.getScreenName(template), template);
    }
}

