/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.pipeline;

import java.io.IOException;
import org.apache.turbine.annotation.TurbineConfiguration;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.pipeline.Valve;
import org.apache.turbine.pipeline.ValveContext;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;

public class DefaultSessionTimeoutValve
implements Valve {
    @TurbineConfiguration(value="session.timeout")
    protected int timeout = -1;

    @Override
    public void invoke(PipelineData pipelineData, ValveContext context) throws IOException, TurbineException {
        RunData runData = pipelineData.getRunData();
        if (runData.getSession().isNew() && this.timeout != -1) {
            runData.getSession().setMaxInactiveInterval(this.timeout);
        }
        context.invokeNext(pipelineData);
    }
}

