/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.pipeline;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.Turbine;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.pipeline.Valve;
import org.apache.turbine.pipeline.ValveContext;
import org.apache.turbine.util.LocaleUtils;
import org.apache.turbine.util.TurbineException;

public class DefaultSetEncodingValve
implements Valve {
    private static final Logger log = LogManager.getLogger(DefaultSetEncodingValve.class);

    @Override
    public void invoke(PipelineData pipelineData, ValveContext context) throws IOException, TurbineException {
        String outputEncoding;
        HttpServletRequest req = pipelineData.get(Turbine.class, HttpServletRequest.class);
        String requestEncoding = req.getCharacterEncoding();
        if (requestEncoding == null) {
            requestEncoding = LocaleUtils.getDefaultInputEncoding();
            log.debug("Changing Input Encoding to {}", (Object)requestEncoding);
            try {
                req.setCharacterEncoding(requestEncoding);
            }
            catch (UnsupportedEncodingException uee) {
                throw new TurbineException("Could not change request encoding to " + requestEncoding, uee);
            }
        }
        if ((outputEncoding = LocaleUtils.getOverrideCharSet()) == null) {
            outputEncoding = requestEncoding;
        }
        pipelineData.getRunData().setCharSet(outputEncoding);
        context.invokeNext(pipelineData);
    }
}

