/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.jsp.util;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.modules.Screen;
import org.apache.turbine.modules.ScreenLoader;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.assemblerbroker.AssemblerBrokerService;
import org.apache.turbine.services.jsp.util.JspNavigation;
import org.apache.turbine.services.template.TemplateService;
import org.apache.turbine.util.RunData;

public class JspScreenPlaceholder {
    private static Logger log = LogManager.getLogger(JspNavigation.class);
    private final RunData data;
    private final ScreenLoader screenLoader;

    public JspScreenPlaceholder(RunData data) {
        this.data = data;
        AssemblerBrokerService abs = (AssemblerBrokerService)TurbineServices.getInstance().getService("AssemblerBrokerService");
        this.screenLoader = (ScreenLoader)abs.getLoader(Screen.class);
    }

    public void exec() {
        String template = null;
        String module = null;
        try {
            template = this.data.getTemplateInfo().getScreenTemplate();
            TemplateService templateService = (TemplateService)TurbineServices.getInstance().getService("TemplateService");
            module = templateService.getScreenName(template);
            this.screenLoader.exec(this.data, module);
        }
        catch (Exception e) {
            String message = "Error processing screen template:" + template + " using module: " + module;
            log.error(message, (Throwable)e);
            try {
                this.data.getResponse().getWriter().print(message);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

