/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.velocity;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.Turbine;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.pull.PullService;
import org.apache.turbine.services.template.BaseTemplateEngineService;
import org.apache.turbine.services.velocity.VelocityService;
import org.apache.turbine.util.LocaleUtils;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.MethodExceptionEventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.util.introspection.Info;

public class TurbineVelocityService
extends BaseTemplateEngineService
implements VelocityService,
MethodExceptionEventHandler {
    private static final String RESOURCE_LOADER_PATH = ".resource.loader.path";
    private static final String JAR_PREFIX = "jar:";
    private static final String ABSOLUTE_PREFIX = "file://";
    private static final Logger log = LogManager.getLogger(TurbineVelocityService.class);
    private String defaultInputEncoding;
    private String defaultOutputEncoding;
    private boolean pullModelActive = false;
    private boolean catchErrors = true;
    private VelocityEngine velocity = null;
    private PullService pullService = null;

    @Override
    public void init() throws InitializationException {
        try {
            this.velocity = this.getInitializedVelocityEngine();
            if (TurbineServices.getInstance().isRegistered("PullService")) {
                this.pullModelActive = true;
                this.pullService = (PullService)TurbineServices.getInstance().getService("PullService");
                log.debug("Activated Pull Tools");
            }
            this.registerConfiguration("vm");
            this.defaultInputEncoding = this.getConfiguration().getString("input.encoding", LocaleUtils.getDefaultInputEncoding());
            String outputEncoding = LocaleUtils.getOverrideCharSet();
            if (outputEncoding == null) {
                outputEncoding = this.defaultInputEncoding;
            }
            this.defaultOutputEncoding = this.getConfiguration().getString("output.encoding", this.defaultInputEncoding);
            this.setInit(true);
        }
        catch (Exception e) {
            throw new InitializationException("Failed to initialize TurbineVelocityService", e);
        }
    }

    @Override
    public Context getContext() {
        Context globalContext = this.pullModelActive ? this.pullService.getGlobalContext() : null;
        VelocityContext ctx = new VelocityContext(globalContext);
        return ctx;
    }

    @Override
    public Context getNewContext() {
        VelocityContext ctx = new VelocityContext();
        EventCartridge ec = new EventCartridge();
        ec.addEventHandler((EventHandler)this);
        ec.attachToContext((Context)ctx);
        return ctx;
    }

    public Object methodException(Context context, Class clazz, String method, Exception e, Info info) {
        log.error("Class {}.{} threw Exception", (Object)clazz.getName(), (Object)method, (Object)e);
        if (!this.catchErrors) {
            throw new RuntimeException(e);
        }
        return "[Turbine caught an Error in template " + info.getTemplateName() + ", l:" + info.getLine() + ", c:" + info.getColumn() + ". Look into the turbine.log for further information]";
    }

    @Override
    public Context getContext(PipelineData pipelineData) {
        RunData data = (RunData)pipelineData;
        Context context = (Context)data.getTemplateInfo().getTemplateContext("VELOCITY_CONTEXT");
        if (context == null) {
            context = this.getContext();
            context.put("data", (Object)data);
            context.put("pipelineData", (Object)pipelineData);
            if (this.pullModelActive) {
                this.pullService.populateContext(context, pipelineData);
            }
            data.getTemplateInfo().setTemplateContext("VELOCITY_CONTEXT", context);
        }
        return context;
    }

    @Override
    public String handleRequest(Context context, String filename) throws TurbineException {
        String results = null;
        OutputStreamWriter writer = null;
        String charset = this.getOutputCharSet(context);
        try (ByteArrayOutputStream bytes = new ByteArrayOutputStream();){
            writer = new OutputStreamWriter((OutputStream)bytes, charset);
            this.executeRequest(context, filename, writer);
            writer.flush();
            results = bytes.toString(charset);
        }
        catch (Exception e) {
            TurbineVelocityService.renderingError(filename, e);
        }
        return results;
    }

    @Override
    public void handleRequest(Context context, String filename, OutputStream output) throws TurbineException {
        String charset = this.getOutputCharSet(context);
        try (OutputStreamWriter writer = new OutputStreamWriter(output, charset);){
            this.executeRequest(context, filename, writer);
        }
        catch (Exception e) {
            TurbineVelocityService.renderingError(filename, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(Context context, String filename, Writer writer) throws TurbineException {
        try {
            this.executeRequest(context, filename, writer);
        }
        catch (Exception e) {
            TurbineVelocityService.renderingError(filename, e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.flush();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void executeRequest(Context context, String filename, Writer writer) throws Exception {
        String encoding = this.getTemplateEncoding(context);
        if (encoding == null) {
            encoding = this.defaultOutputEncoding;
        }
        this.velocity.mergeTemplate(filename, encoding, context, writer);
    }

    private String getOutputCharSet(Context context) {
        String charset = null;
        Object data = context.get("data");
        if (data != null && data instanceof RunData) {
            charset = ((RunData)data).getCharSet();
        }
        return StringUtils.isEmpty(charset) ? this.defaultOutputEncoding : charset;
    }

    private String getTemplateEncoding(Context context) {
        String encoding = null;
        Object data = context.get("data");
        if (data != null && data instanceof RunData) {
            encoding = ((RunData)data).getTemplateEncoding();
        }
        return encoding != null ? encoding : this.defaultInputEncoding;
    }

    private static final void renderingError(String filename, Exception e) throws TurbineException {
        String err = "Error rendering Velocity template: " + filename;
        log.error(err, (Throwable)e);
        throw new TurbineException(err, e);
    }

    private VelocityEngine getInitializedVelocityEngine() throws Exception {
        Configuration conf = this.getConfiguration();
        this.catchErrors = conf.getBoolean("catch.errors", true);
        conf.setProperty("runtime.log.name", (Object)"velocity");
        VelocityEngine velocity = new VelocityEngine();
        this.setVelocityProperties(velocity, conf);
        velocity.init();
        return velocity;
    }

    protected void setVelocityProperties(VelocityEngine velocity, Configuration conf) throws Exception {
        Iterator i = conf.getKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.endsWith(RESOURCE_LOADER_PATH)) {
                Object value = conf.getProperty(key);
                if (value instanceof List) {
                    Iterator itr = ((List)value).iterator();
                    while (itr.hasNext()) {
                        velocity.addProperty(key, itr.next());
                    }
                    continue;
                }
                velocity.addProperty(key, value);
                continue;
            }
            List paths = conf.getList(key, null);
            if (paths == null) continue;
            for (Object p : paths) {
                String path = (String)p;
                log.debug("Translating {}", (Object)path);
                if (path.startsWith(JAR_PREFIX)) {
                    if (path.substring(4).startsWith(ABSOLUTE_PREFIX)) {
                        int jarSepIndex = path.indexOf("!/");
                        path = jarSepIndex < 0 ? Turbine.getRealPath(path.substring(11)) : Turbine.getRealPath(path.substring(11, jarSepIndex)) + path.substring(jarSepIndex);
                        log.debug("Result (absolute jar path): {}", (Object)path);
                    }
                } else if (path.startsWith(ABSOLUTE_PREFIX)) {
                    path = Turbine.getRealPath(path.substring(7));
                    log.debug("Result (absolute URL Path): {}", (Object)path);
                } else if (path.indexOf("://") < 0) {
                    path = Turbine.getRealPath(path);
                    log.debug("Result (normal fs reference): {}", (Object)path);
                }
                log.debug("Adding {} -> {}", (Object)key, (Object)path);
                velocity.addProperty(key, (Object)path);
            }
        }
    }

    @Override
    public boolean templateExists(String template) {
        return this.velocity.resourceExists(template);
    }

    @Override
    public void requestFinished(Context context) {
        if (this.pullModelActive) {
            this.pullService.releaseTools(context);
        }
    }
}

