/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.framework.container;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.fulcrum.yaafi.framework.component.AvalonServiceComponentImpl;
import org.apache.fulcrum.yaafi.framework.component.ServiceComponent;
import org.apache.fulcrum.yaafi.framework.configuration.ComponentConfigurationPropertiesResolver;
import org.apache.fulcrum.yaafi.framework.configuration.ComponentConfigurationPropertiesResolverImpl;
import org.apache.fulcrum.yaafi.framework.container.ServiceConstants;
import org.apache.fulcrum.yaafi.framework.container.ServiceContainer;
import org.apache.fulcrum.yaafi.framework.context.AvalonToYaafiContextMapper;
import org.apache.fulcrum.yaafi.framework.context.YaafiToAvalonContextMapper;
import org.apache.fulcrum.yaafi.framework.crypto.CryptoStreamFactory;
import org.apache.fulcrum.yaafi.framework.role.RoleConfigurationParser;
import org.apache.fulcrum.yaafi.framework.role.RoleConfigurationParserImpl;
import org.apache.fulcrum.yaafi.framework.role.RoleEntry;
import org.apache.fulcrum.yaafi.framework.util.ConfigurationUtil;
import org.apache.fulcrum.yaafi.framework.util.InputStreamLocator;
import org.apache.fulcrum.yaafi.framework.util.ToStringBuilder;
import org.apache.fulcrum.yaafi.framework.util.Validate;

public class ServiceContainerImpl
implements ServiceContainer,
ServiceConstants {
    private static final int DISPOSAL_DELAY_DEFAULT = 0;
    private static final int RECONFIGURATION_DELAY_DEFAULT = 2000;
    private String componentRolesLocation = "/componentRoles.xml";
    private String isComponentRolesEncrypted = "false";
    private String componentRolesFlavour = "yaafi";
    private String componentConfigurationLocation = "/componentConfiguration.xml";
    private String isComponentConfigurationEncrypted = "false";
    private String parametersLocation = "/parameters.properties";
    private String isParametersEncrypted = "false";
    private File applicationRootDir;
    private File tempRootDir;
    private Logger logger;
    private ServiceManager parentServiceManager;
    private List<ServiceComponent> serviceList = new ArrayList<ServiceComponent>();
    private HashMap<String, ServiceComponent> serviceMap = new HashMap();
    private Configuration roleConfiguration;
    private Configuration serviceConfiguration;
    private Context callerContext;
    private Context context;
    private Parameters parameters;
    private volatile boolean isAlreadyDisposed = false;
    private volatile boolean isCurrentlyDisposing = false;
    private String containerFlavour = "yaafi";
    private int reconfigurationDelay = 2000;
    private int disposalDelay = 0;
    private boolean hasDynamicProxies;
    private ArrayList<String> defaultInterceptorServiceList;
    private ArrayList<String> fallbackServiceManagerList;
    private Configuration componentConfigurationPropertiesResolverConfig;

    public ServiceContainerImpl() {
        this.applicationRootDir = new File(new File("").getAbsolutePath());
        this.tempRootDir = new File(System.getProperty("java.io.tmpdir", "."));
        this.fallbackServiceManagerList = new ArrayList();
        this.defaultInterceptorServiceList = new ArrayList();
    }

    public void enableLogging(Logger logger) {
        Validate.notNull(logger, "logger");
        this.logger = logger;
    }

    public void contextualize(Context context) throws ContextException {
        Validate.notNull(context, "context");
        this.callerContext = context;
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.parentServiceManager = serviceManager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Validate.notNull(configuration, "configuration");
        this.reconfigurationDelay = configuration.getChild("reconfigurationDelay").getValueAsInteger(2000);
        this.disposalDelay = configuration.getChild("disposalDelay").getValueAsInteger(0);
        this.hasDynamicProxies = configuration.getChild("hasDynamicProxies").getValueAsBoolean(false);
        this.setContainerFlavour(configuration.getChild("containerFlavour").getValue("yaafi"));
        this.getLogger().debug("Using the following container type : " + this.getContainerFlavour());
        try {
            AvalonToYaafiContextMapper mapper = new AvalonToYaafiContextMapper(this.getTempRootDir(), this.callerContext, this.getClassLoader());
            this.context = mapper.mapFrom(this.callerContext, this.getContainerFlavour());
            this.callerContext = null;
        }
        catch (ContextException e) {
            String msg = "Failed to parse the caller-supplied context";
            this.getLogger().error(msg, (Throwable)e);
            throw new ConfigurationException(msg);
        }
        Configuration currComponentRoles = configuration.getChild("componentRoles");
        this.setComponentRolesLocation(currComponentRoles.getChild("location").getValue("/componentRoles.xml"));
        this.setComponentRolesFlavour(currComponentRoles.getChild("containerFlavour").getValue("yaafi"));
        this.setComponentRolesEncrypted(currComponentRoles.getChild("isEncrypted").getValue("false"));
        Configuration currComponentConfiguration = configuration.getChild("componentConfiguration");
        this.setComponentConfigurationLocation(currComponentConfiguration.getChild("location").getValue("/componentConfiguration.xml"));
        this.setComponentConfigurationEncrypted(currComponentConfiguration.getChild("isEncrypted").getValue("false"));
        this.componentConfigurationPropertiesResolverConfig = configuration.getChild("componentConfigurationProperties");
        Configuration currParameters = configuration.getChild("parameters");
        this.setParametersLocation(currParameters.getChild("location").getValue("/parameters.properties"));
        this.setParametersEncrypted(currParameters.getChild("isEncrypted").getValue("false"));
        Configuration currInterceptorList = configuration.getChild("interceptors");
        Configuration[] interceptorConfigList = currInterceptorList.getChildren("interceptor");
        for (int i = 0; i < interceptorConfigList.length; ++i) {
            String interceptorServiceName = interceptorConfigList[i].getValue(null);
            if (StringUtils.isEmpty((CharSequence)interceptorServiceName) || !this.hasDynamicProxies()) continue;
            this.defaultInterceptorServiceList.add(interceptorServiceName);
            this.getLogger().debug("Using the following default interceptor service : " + interceptorServiceName);
        }
        Configuration currServiceManagerList = configuration.getChild("serviceManagers");
        Configuration[] serviceManagerConfigList = currServiceManagerList.getChildren("serviceManager");
        for (int i = 0; i < serviceManagerConfigList.length; ++i) {
            String serviceManagerName = serviceManagerConfigList[i].getValue(null);
            if (StringUtils.isEmpty((CharSequence)serviceManagerName)) continue;
            this.fallbackServiceManagerList.add(serviceManagerName);
            this.getLogger().debug("Using the following fallback service manager : " + serviceManagerName);
        }
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.parameters = parameters;
    }

    public void initialize() throws Exception {
        int i;
        this.getLogger().debug("YAAFI Service Framework is starting up");
        this.setApplicationRootDir((File)this.getContext().get((Object)"urn:avalon:home"));
        this.setTempRootDir((File)this.getContext().get((Object)"urn:avalon:temp"));
        this.roleConfiguration = this.loadConfiguration(this.componentRolesLocation, this.isComponentRolesEncrypted());
        if (this.roleConfiguration == null) {
            String msg = "Unable to locate the role configuration : " + this.componentRolesLocation;
            this.getLogger().error(msg);
            throw new ConfigurationException(msg);
        }
        this.serviceConfiguration = this.loadConfiguration(this.componentConfigurationLocation, this.isComponentConfigurationEncrypted());
        Properties componentConfigurationProperties = this.loadComponentConfigurationProperties();
        ConfigurationUtil.expand(this.getLogger(), (DefaultConfiguration)this.serviceConfiguration, componentConfigurationProperties);
        if (this.getParameters() == null) {
            this.parameters = this.loadParameters(this.parametersLocation, this.isParametersEncrypted());
        }
        List<ServiceComponent> currServiceList = this.createServiceComponents(this.roleConfiguration, this.getLogger());
        this.setServiceList(currServiceList);
        for (i = 0; i < this.getServiceList().size(); ++i) {
            ServiceComponent serviceComponent = this.getServiceList().get(i);
            this.getServiceMap().put(serviceComponent.getName(), serviceComponent);
        }
        for (i = 0; i < this.fallbackServiceManagerList.size(); ++i) {
            String currServiceManagerName = this.fallbackServiceManagerList.get(i);
            if (this.getServiceMap().get(currServiceManagerName) != null) continue;
            String msg = "The following fallback service manager was not found : " + currServiceManagerName;
            throw new IllegalArgumentException(msg);
        }
        this.incarnateAll(this.getServiceList());
        this.isCurrentlyDisposing = false;
        this.isAlreadyDisposed = false;
        this.getLogger().debug("YAAFI Avalon Service Container is up and running");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.isCurrentlyDisposing() || this.isAlreadyDisposed()) {
            return;
        }
        this.isCurrentlyDisposing = true;
        if (this.getLogger() != null) {
            this.getLogger().debug("Disposing all services");
        }
        this.waitForDisposal();
        ServiceContainerImpl serviceContainerImpl = this;
        synchronized (serviceContainerImpl) {
            this.decommissionAll(this.getServiceList());
            this.disposeAll(this.getServiceList());
            this.getServiceList().clear();
            this.getServiceMap().clear();
            this.componentRolesLocation = null;
            this.componentConfigurationLocation = null;
            this.context = null;
            this.parametersLocation = null;
            this.roleConfiguration = null;
            this.serviceConfiguration = null;
            this.parameters = null;
            this.fallbackServiceManagerList = null;
            this.defaultInterceptorServiceList = null;
            this.isCurrentlyDisposing = false;
            this.isAlreadyDisposed = true;
            if (this.getLogger() != null) {
                this.getLogger().debug("All services are disposed");
            }
        }
    }

    public synchronized void reconfigure(Configuration configuration) throws ConfigurationException {
        Validate.notNull(configuration, "configuration");
        int exceptionCounter = 0;
        this.getLogger().warn("Reconfiguring all services ...");
        this.waitForReconfiguration();
        this.serviceConfiguration = configuration;
        Properties componentConfigurationProperties = this.loadComponentConfigurationProperties();
        ConfigurationUtil.expand(this.getLogger(), (DefaultConfiguration)this.serviceConfiguration, componentConfigurationProperties);
        for (int i = 0; i < this.getServiceList().size(); ++i) {
            ServiceComponent serviceComponent = this.getServiceList().get(i);
            Configuration serviceComponentConfiguration = this.serviceConfiguration.getChild(serviceComponent.getShorthand());
            try {
                serviceComponent.setConfiguration(serviceComponentConfiguration);
                serviceComponent.reconfigure();
                continue;
            }
            catch (Throwable t) {
                String msg = "Reconfiguring of " + serviceComponent.getShorthand() + " failed";
                this.getLogger().error(msg);
                ++exceptionCounter;
            }
        }
        if (exceptionCounter > 0) {
            String msg = "The reconfiguration failed with " + exceptionCounter + " exception(s)";
            this.getLogger().error(msg);
            throw new ConfigurationException(msg);
        }
    }

    @Override
    public synchronized RoleEntry getRoleEntry(String name) throws ServiceException {
        return this.getServiceComponentEx(name).getRoleEntry();
    }

    @Override
    public synchronized RoleEntry[] getRoleEntries() {
        List<ServiceComponent> serviceList = this.getServiceList();
        RoleEntry[] result = new RoleEntry[serviceList.size()];
        for (int i = 0; i < result.length; ++i) {
            ServiceComponent serviceComponent = serviceList.get(i);
            result[i] = serviceComponent.getRoleEntry();
        }
        return result;
    }

    @Override
    public synchronized void reconfigure(String[] names) throws ServiceException, ConfigurationException {
        Validate.notNull(names, "names");
        Validate.noNullElements(names, "names");
        this.waitForReconfiguration();
        for (int i = 0; i < names.length; ++i) {
            if (this.getServiceMap().get(names[i]) == null) continue;
            this.reconfigure(names[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasService(String name) {
        boolean result;
        Validate.notEmpty(name, "name");
        if (this.isCurrentlyDisposing() || this.isAlreadyDisposed()) {
            return false;
        }
        ServiceContainerImpl serviceContainerImpl = this;
        synchronized (serviceContainerImpl) {
            boolean bl = result = this.getLocalServiceComponent(name) != null;
            if (!result) {
                result = this.hasFallbackService(name);
            }
        }
        if (!result && this.hasParentServiceManager()) {
            result = this.getParentServiceManager().hasService(name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(String name) throws ServiceException {
        Object msg2;
        Validate.notEmpty(name, "name");
        Object result = null;
        if (this.isAlreadyDisposed()) {
            String msg2 = "The container is disposed an no services are available";
            this.getLogger().error(msg2);
            throw new ServiceException(name, msg2);
        }
        try {
            msg2 = this;
            synchronized (msg2) {
                ServiceComponent serviceManagerComponent = this.getLocalServiceComponent(name);
                if (serviceManagerComponent != null && (result = serviceManagerComponent.getInstance()) != null && this.getLogger().isDebugEnabled()) {
                    String msg3 = "Located the service '" + name + "' in the local container";
                    this.getLogger().debug(msg3);
                }
                if (result == null) {
                    result = this.getFallbackService(name);
                }
            }
        }
        catch (ServiceException e) {
            String msg4 = "Failed to lookup a service " + name;
            this.getLogger().error(msg4, (Throwable)e);
            throw e;
        }
        catch (Throwable t) {
            String msg5 = "Failed to lookup a service " + name;
            this.getLogger().error(msg5, t);
            throw new ServiceException(name, msg5, t);
        }
        if (result == null && this.hasParentServiceManager() && (result = this.getParentServiceManager().lookup(name)) != null && this.getLogger().isDebugEnabled()) {
            msg2 = "Located the service '" + name + "' using the parent service manager";
            this.getLogger().debug((String)msg2);
        }
        if (result == null) {
            msg2 = "The following component does not exist : " + name;
            this.getLogger().error((String)msg2);
            throw new ServiceException("yaafi", name);
        }
        return result;
    }

    public void release(Object object) {
    }

    @Override
    public synchronized void decommission(String name) throws ServiceException {
        this.waitForReconfiguration();
        ServiceComponent serviceComponent = this.getServiceComponentEx(name);
        this.decommission(serviceComponent);
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder(this);
        toStringBuilder.append("applicationRootDir", this.getApplicationRootDir());
        toStringBuilder.append("tempRootDir", this.getTempRootDir());
        toStringBuilder.append("componentRolesLocation", this.componentRolesLocation);
        toStringBuilder.append("componentConfigurationLocation", this.componentConfigurationLocation);
        toStringBuilder.append("parametersLocation", this.parametersLocation);
        toStringBuilder.append("logger", this.getLogger().getClass().getName());
        toStringBuilder.append("hasDynamicProxies", this.hasDynamicProxies);
        toStringBuilder.append("containerFlavour", this.containerFlavour);
        toStringBuilder.append("componentRolesFlavour", this.componentRolesFlavour);
        toStringBuilder.append("isComponentRolesEncrypted", this.isComponentRolesEncrypted);
        toStringBuilder.append("isComponentConfigurationEncrypted", this.isComponentConfigurationEncrypted);
        toStringBuilder.append("isParametersEncrypted", this.isParametersEncrypted);
        return toStringBuilder.toString();
    }

    private RoleConfigurationParser createRoleConfigurationParser() {
        return new RoleConfigurationParserImpl(this.getComponentRolesFlavour());
    }

    private void reconfigure(String name) throws ServiceException, ConfigurationException {
        Validate.notEmpty(name, "name");
        ServiceComponent serviceComponent = this.getServiceComponentEx(name);
        try {
            serviceComponent.reconfigure();
        }
        catch (ConfigurationException e) {
            String msg = "Reconfiguring failed : " + serviceComponent.getShorthand();
            this.getLogger().error(msg, (Throwable)e);
            throw new ConfigurationException(msg, (Throwable)e);
        }
        catch (Throwable t) {
            String msg = "Reconfiguring failed : " + serviceComponent.getShorthand();
            this.getLogger().error(msg, t);
            throw new ConfigurationException(msg, t);
        }
    }

    private ServiceComponent getServiceComponentEx(String name) throws ServiceException {
        Validate.notEmpty(name, "name");
        ServiceComponent result = this.getServiceMap().get(name);
        if (result == null) {
            String msg = "The following component does not exist : " + name;
            this.getLogger().error(msg);
            throw new ServiceException("yaafi", name);
        }
        return result;
    }

    private ServiceComponent getLocalServiceComponent(String name) {
        Validate.notEmpty(name, "name");
        ServiceComponent result = this.getServiceMap().get(name);
        return result;
    }

    private Object getFallbackService(String name) throws Exception {
        Validate.notEmpty(name, "name");
        Object result = null;
        for (int i = 0; i < this.fallbackServiceManagerList.size(); ++i) {
            ServiceManager currServiceManager;
            String serviceManagerComponentName = this.fallbackServiceManagerList.get(i);
            ServiceComponent serviceManagerComponent = this.getLocalServiceComponent(serviceManagerComponentName);
            if (serviceManagerComponent == null || !(currServiceManager = (ServiceManager)serviceManagerComponent.getInstance()).hasService(name) || (result = currServiceManager.lookup(name)) == null || !this.getLogger().isDebugEnabled()) continue;
            String msg = "Located the service '" + name + "' using the fallback service manager '" + serviceManagerComponentName + "'";
            this.getLogger().debug(msg);
        }
        return result;
    }

    private boolean hasFallbackService(String name) {
        Validate.notEmpty(name, "name");
        for (int i = 0; i < this.fallbackServiceManagerList.size(); ++i) {
            String serviceManagerComponentName = this.fallbackServiceManagerList.get(i);
            ServiceComponent serviceManagerComponent = this.getLocalServiceComponent(serviceManagerComponentName);
            if (serviceManagerComponent == null) continue;
            try {
                ServiceManager currServiceManager = (ServiceManager)serviceManagerComponent.getInstance();
                if (!currServiceManager.hasService(name)) continue;
                return true;
            }
            catch (Exception e) {
                String msg = "Unable to invoke fallback service manager '" + serviceManagerComponentName + "'";
                this.getLogger().error(msg, (Throwable)e);
                throw new RuntimeException(msg);
            }
        }
        return false;
    }

    private void setComponentConfigurationLocation(String string) {
        this.componentConfigurationLocation = string;
    }

    private void setComponentRolesLocation(String string) {
        this.componentRolesLocation = string;
    }

    private void setParametersLocation(String string) {
        this.parametersLocation = string;
    }

    private Logger getLogger() {
        return this.logger;
    }

    private HashMap<String, ServiceComponent> getServiceMap() {
        return this.serviceMap;
    }

    private void incarnateAll(List<ServiceComponent> serviceList) throws Exception {
        ServiceComponent serviceComponent;
        int i;
        for (i = 0; i < serviceList.size(); ++i) {
            serviceComponent = this.getServiceList().get(i);
            this.configure(serviceComponent);
        }
        for (i = 0; i < serviceList.size(); ++i) {
            serviceComponent = this.getServiceList().get(i);
            this.incarnate(serviceComponent);
        }
    }

    private void configure(ServiceComponent serviceComponent) throws Exception {
        this.getLogger().debug("Configuring the service component " + serviceComponent.getShorthand());
        YaafiToAvalonContextMapper mapper = new YaafiToAvalonContextMapper(serviceComponent.getName(), this.getClassLoader());
        RoleEntry roleEntry = serviceComponent.getRoleEntry();
        String componentFlavour = roleEntry.getComponentFlavour();
        DefaultContext serviceComponentContext = mapper.mapTo(this.getContext(), componentFlavour);
        Logger serviceComponentLogger = this.getLogger().getChildLogger(roleEntry.getLogCategory());
        Configuration serviceComponentConfiguration = this.serviceConfiguration.getChild(roleEntry.getShorthand());
        Parameters serviceComponentParameters = this.getParameters();
        serviceComponent.setLogger(serviceComponentLogger);
        serviceComponent.setServiceManager(this);
        serviceComponent.setContext((Context)serviceComponentContext);
        serviceComponent.setConfiguration(serviceComponentConfiguration);
        serviceComponent.setParameters(serviceComponentParameters);
        serviceComponent.loadImplemtationClass(this.getClassLoader());
    }

    private void incarnate(ServiceComponent serviceComponent) throws Exception {
        this.getLogger().debug("Incarnating the service " + serviceComponent.getShorthand());
        serviceComponent.incarnate();
    }

    private void decommissionAll(List<ServiceComponent> serviceList) {
        for (int i = serviceList.size() - 1; i >= 0; --i) {
            ServiceComponent serviceComponent = serviceList.get(i);
            this.decommission(serviceComponent);
        }
    }

    private void decommission(ServiceComponent serviceComponent) {
        this.getLogger().debug("Decommission the service " + serviceComponent.getShorthand());
        try {
            serviceComponent.decommision();
        }
        catch (Throwable e) {
            String msg = "Decommissioning the following service failed : " + serviceComponent.getName();
            this.getLogger().error(msg, e);
        }
    }

    private void disposeAll(List<ServiceComponent> serviceList) {
        for (int i = serviceList.size() - 1; i >= 0; --i) {
            ServiceComponent serviceComponent = serviceList.get(i);
            this.dispose(serviceComponent);
        }
    }

    private void dispose(ServiceComponent serviceComponent) {
        this.getLogger().debug("Disposing the service " + serviceComponent.getShorthand());
        try {
            serviceComponent.dispose();
        }
        catch (Throwable e) {
            String msg = "Disposing the following service failed : " + serviceComponent.getName();
            this.getLogger().error(msg, e);
        }
    }

    private boolean isCurrentlyDisposing() {
        return this.isCurrentlyDisposing;
    }

    private boolean isAlreadyDisposed() {
        return this.isAlreadyDisposed;
    }

    private List<ServiceComponent> getServiceList() {
        return this.serviceList;
    }

    private void setServiceList(List<ServiceComponent> list) {
        this.serviceList = list;
    }

    private List<ServiceComponent> createServiceComponents(Configuration roleConfiguration, Logger logger) throws ConfigurationException {
        Validate.notNull(roleConfiguration, "roleConfiguration");
        Validate.notNull(logger, "logger");
        ArrayList<ServiceComponent> result = new ArrayList<ServiceComponent>();
        ServiceComponent serviceComponent = null;
        RoleConfigurationParser roleConfigurationParser = this.createRoleConfigurationParser();
        RoleEntry[] roleEntryList = roleConfigurationParser.parse(roleConfiguration);
        ArrayList<String> defaultInterceptorList = this.getDefaultInterceptorServiceList();
        for (int i = 0; i < roleEntryList.length; ++i) {
            try {
                RoleEntry roleEntry = roleEntryList[i];
                if (this.hasDynamicProxies()) {
                    roleEntry.addInterceptors(defaultInterceptorList);
                } else {
                    roleEntry.setHasDynamicProxy(false);
                }
                serviceComponent = new AvalonServiceComponentImpl(roleEntry, this.getLogger(), logger);
                result.add(serviceComponent);
                continue;
            }
            catch (Throwable t) {
                String serviceComponentName = serviceComponent != null ? serviceComponent.getName() : "unknown";
                String msg = "Failed to load the service " + serviceComponentName;
                this.getLogger().error(msg, t);
                throw new ConfigurationException(msg, t);
            }
        }
        return result;
    }

    private Configuration loadConfiguration(String location, String isEncrypted) throws Exception {
        Configuration result = null;
        InputStreamLocator locator = this.createInputStreamLocator();
        InputStream is = locator.locate(location);
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        if (is != null) {
            try {
                is = this.getDecryptingInputStream(is, isEncrypted);
                result = builder.build(is);
            }
            catch (Exception e) {
                String msg = "Unable to parse the following file : " + location;
                this.getLogger().error(msg, (Throwable)e);
                throw e;
            }
            finally {
                this.safeClose(is);
            }
        }
        return result;
    }

    private Properties loadComponentConfigurationProperties() throws ConfigurationException {
        Properties result;
        String className = this.componentConfigurationPropertiesResolverConfig.getChild("resolver").getValue(ComponentConfigurationPropertiesResolverImpl.class.getName());
        try {
            Class<?> resolverClass = this.getClassLoader().loadClass(className);
            ComponentConfigurationPropertiesResolver resolver = (ComponentConfigurationPropertiesResolver)resolverClass.newInstance();
            ContainerUtil.enableLogging((Object)resolver, (Logger)this.getLogger());
            ContainerUtil.contextualize((Object)resolver, (Context)this.getContext());
            ContainerUtil.configure((Object)resolver, (Configuration)this.componentConfigurationPropertiesResolverConfig);
            result = resolver.resolve(null);
            this.getLogger().debug("Using the following componentConfigurationProperties: " + result);
        }
        catch (Exception e) {
            String msg = "Resolving componentConfigurationProperties failed using the following class : " + className;
            this.getLogger().error(msg, (Throwable)e);
            throw new ConfigurationException(msg, (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Parameters loadParameters(String location, String isEncrypted) throws Exception {
        InputStreamLocator locator = this.createInputStreamLocator();
        InputStream is = locator.locate(location);
        Parameters result = new Parameters();
        if (is != null) {
            try {
                is = this.getDecryptingInputStream(is, isEncrypted);
                Properties props = new Properties();
                props.load(is);
                result = Parameters.fromProperties((Properties)props);
            }
            finally {
                this.safeClose(is);
            }
        }
        return result;
    }

    private InputStreamLocator createInputStreamLocator() {
        return new InputStreamLocator(this.getApplicationRootDir(), this.getLogger());
    }

    private void setApplicationRootDir(File dir) {
        this.getLogger().debug("Setting applicationRootDir to " + dir.getAbsolutePath());
        Validate.notNull(dir, "applicationRootDir is <null>");
        Validate.isTrue(dir.exists(), "applicationRootDir does not exist");
        this.applicationRootDir = dir;
    }

    private File getApplicationRootDir() {
        return this.applicationRootDir;
    }

    private ServiceManager getParentServiceManager() {
        return this.parentServiceManager;
    }

    private boolean hasParentServiceManager() {
        return this.getParentServiceManager() != null;
    }

    private void setTempRootDir(File dir) {
        this.getLogger().debug("Setting tempRootDir to " + dir.getAbsolutePath());
        Validate.notNull(dir, "tempRootDir is <null>");
        Validate.isTrue(dir.exists(), "tempRootDir does not exist");
        Validate.isTrue(dir.canWrite(), "tempRootDir is not writeable");
        this.tempRootDir = dir;
    }

    private File getTempRootDir() {
        return this.tempRootDir;
    }

    private String isComponentConfigurationEncrypted() {
        return this.isComponentConfigurationEncrypted;
    }

    private void setComponentConfigurationEncrypted(String isComponentConfigurationEncrypted) {
        this.isComponentConfigurationEncrypted = isComponentConfigurationEncrypted;
    }

    private String isComponentRolesEncrypted() {
        return this.isComponentRolesEncrypted;
    }

    private void setComponentRolesEncrypted(String isComponentRolesEncrypted) {
        this.isComponentRolesEncrypted = isComponentRolesEncrypted;
    }

    private String isParametersEncrypted() {
        return this.isParametersEncrypted;
    }

    private void setParametersEncrypted(String isParametersEncrypted) {
        this.isParametersEncrypted = isParametersEncrypted;
    }

    private InputStream getDecryptingInputStream(InputStream is, String isEncrypted) throws Exception {
        return CryptoStreamFactory.getDecryptingInputStream(is, isEncrypted);
    }

    private String getContainerFlavour() {
        return this.containerFlavour;
    }

    private void setContainerFlavour(String containerFlavour) {
        this.containerFlavour = containerFlavour;
    }

    private String getComponentRolesFlavour() {
        return this.componentRolesFlavour;
    }

    private void setComponentRolesFlavour(String componentRolesFlavour) {
        this.componentRolesFlavour = componentRolesFlavour;
    }

    private Context getContext() {
        return this.context;
    }

    private boolean hasDynamicProxies() {
        return this.hasDynamicProxies;
    }

    private ArrayList<String> getDefaultInterceptorServiceList() {
        return this.defaultInterceptorServiceList;
    }

    private ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    private void waitForReconfiguration() {
        try {
            Thread.sleep(this.reconfigurationDelay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void waitForDisposal() {
        try {
            Thread.sleep(this.disposalDelay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void safeClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception e) {
                this.getLogger().error("Failed to close an input stream", (Throwable)e);
            }
        }
    }
}

