/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.framework.util;

import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.logger.Logger;

public class ConfigurationUtil {
    public static void expand(Logger logger, DefaultConfiguration defaultConfiguration, Map<?, ?> vars) throws ConfigurationException {
        if (vars == null || vars.size() == 0) {
            return;
        }
        if (defaultConfiguration.getValue(null) != null) {
            String oldValue = defaultConfiguration.getValue();
            String newValue = ConfigurationUtil.expand(oldValue, vars);
            defaultConfiguration.setValue(newValue);
            if (!oldValue.equals(newValue)) {
                logger.debug("Changed element <" + defaultConfiguration.getName() + "> from '" + oldValue + "' ==> '" + newValue + "'");
            }
        }
        String attributeName = null;
        String[] attributeNames = defaultConfiguration.getAttributeNames();
        for (int i = 0; i < attributeNames.length; ++i) {
            attributeName = attributeNames[i];
            String oldAttributeValue = defaultConfiguration.getAttribute(attributeName);
            String newAttributeValue = ConfigurationUtil.expand(oldAttributeValue, vars);
            defaultConfiguration.setAttribute(attributeName, newAttributeValue);
            if (oldAttributeValue.equals(newAttributeValue)) continue;
            logger.debug("Changed attribute '" + defaultConfiguration.getName() + "@" + attributeName + "' from '" + oldAttributeValue + "' ==> '" + newAttributeValue + "'");
        }
        Configuration[] children = defaultConfiguration.getChildren();
        for (int i = 0; i < children.length; ++i) {
            ConfigurationUtil.expand(logger, (DefaultConfiguration)children[i], vars);
        }
    }

    private static String expand(String argStr, Map<?, ?> vars) {
        boolean isLenient = true;
        StringBuilder argBuf = new StringBuilder();
        int argStrLength = argStr.length();
        int cIdx = 0;
        block3: while (cIdx < argStrLength) {
            char ch = argStr.charAt(cIdx);
            int del = 32;
            switch (ch) {
                case '$': {
                    StringBuilder nameBuf = new StringBuilder();
                    del = argStr.charAt(cIdx + 1);
                    if (del == 123) {
                        ++cIdx;
                        ++cIdx;
                        while (cIdx < argStr.length() && (ch = argStr.charAt(cIdx)) != '}') {
                            nameBuf.append(ch);
                            ++cIdx;
                        }
                        if (nameBuf.length() > 0) {
                            Object value = vars.get(nameBuf.toString());
                            if (value != null) {
                                argBuf.append(value.toString());
                            } else {
                                if (!isLenient) {
                                    throw new RuntimeException("No value found for : " + nameBuf);
                                }
                                argBuf.append("${").append((CharSequence)nameBuf).append("}");
                            }
                            del = argStr.charAt(cIdx);
                            if (del != 125) {
                                throw new RuntimeException("Delimineter not found for : " + nameBuf);
                            }
                        }
                        ++cIdx;
                        continue block3;
                    }
                    argBuf.append(ch);
                    ++cIdx;
                    continue block3;
                }
            }
            argBuf.append(ch);
            ++cIdx;
        }
        return argBuf.toString();
    }
}

