/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.dde.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.uima.aae.deployment.AEDeploymentDescription;
import org.apache.uima.aae.deployment.impl.AEDeploymentDescription_Impl;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.application.metadata.impl.UimaApplication_Impl;
import org.apache.uima.dde.internal.Messages;
import org.apache.uima.dde.internal.page.AEConfigurationPage;
import org.apache.uima.dde.internal.page.OverviewPage;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.MultiPageEditorContributor;
import org.apache.uima.taeconfigurator.editors.point.IUimaEditorExtension;
import org.apache.uima.taeconfigurator.editors.point.IUimaMultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.apache.uima.taeconfigurator.editors.xml.XMLEditor;
import org.apache.uima.tools.internal.cde.uima.util.UimaDescriptionUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLizable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;

public class DeploymentDescriptorEditor
implements IUimaMultiPageEditor,
IUimaEditorExtension {
    protected boolean isBadXML = true;
    public static final String ID = "com.ibm.apache.uima.dde.internal.MultiPageEditor";
    public static final String TITLE = "UIMA DDE";
    public static final String VERSION = "0.1.2";
    public MultiPageEditor cde;
    private IFile inputIFile;
    private AEDeploymentDescription aeDD;
    private OverviewPage overviewPage;
    private AEConfigurationPage aeConfigPage;
    private XMLEditor sourceTextEditor;
    protected int sourceIndex = -1;
    boolean isPageChangeRecursion = false;
    private IJavaProject javaProject = null;

    public void init() {
        UimaApplication_Impl.initUimaApplicationFramework();
    }

    public boolean canEdit(MultiPageEditor cde, XMLizable xmlizable) {
        return xmlizable instanceof AEDeploymentDescription;
    }

    public void activateEditor(IEditorSite site, IEditorInput editorInput, MultiPageEditor cde, XMLizable xmlizable) throws PartInitException {
        this.cde = cde;
        this.aeDD = (AEDeploymentDescription)xmlizable;
        this.inputIFile = ((IFileEditorInput)cde.getEditorInput()).getFile();
        cde.setPartNameSuper(this.inputIFile.getName() + " (" + VERSION + ")");
        this.isBadXML = false;
        if (cde.getSourceEditor() != null) {
            this.sourceTextEditor = cde.getSourceEditor();
        }
    }

    public void setFileDirty() {
        this.cde.setFileDirty();
    }

    public AEDeploymentDescription getAEDeploymentDescription() {
        return this.aeDD;
    }

    public void refresh() {
        this.aeConfigPage.setInput(this.aeDD);
    }

    public void setInput() {
        this.overviewPage.setInput(this.aeDD);
        this.aeConfigPage.setInput(this.aeDD);
    }

    public OverviewPage getOverviewPage() {
        return this.overviewPage;
    }

    public void addPagesForCurrentEditor() {
        try {
            if (this.aeDD != null) {
                try {
                    ResourceSpecifier aed = this.aeDD.getAeService().resolveTopAnalysisEngineDescription(this.cde.createResourceManager(), false);
                    if (aed instanceof AnalysisEngineDescription && !((AnalysisEngineDescription)aed).isPrimitive()) {
                        this.aeDD.getAeService().getAnalysisEngineDeploymentMetaData().resolveDelegates(this.cde.createResourceManager(), true);
                    }
                }
                catch (InvalidXMLException e) {
                    e.printStackTrace();
                    this.isBadXML = true;
                    Utility.popMessage((String)Messages.getString("InvalidXMLException"), (String)this.cde.getMessagesToRootCause((Throwable)e), (int)1);
                }
            }
            if (!this.isBadXML) {
                this.overviewPage = new OverviewPage(this, "123", "Overview");
                this.cde.addPage((IFormPage)this.overviewPage);
                this.aeConfigPage = new AEConfigurationPage(this, "123", "Deployment Configurations");
                this.cde.addPage((IFormPage)this.aeConfigPage);
            }
            this.createSourcePage();
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        if (this.isBadXML) {
            this.pageChangeForCurrentEditor(this.sourceIndex);
        }
    }

    protected void createSourcePage() {
        if (this.sourceTextEditor != null) {
            return;
        }
        try {
            this.sourceTextEditor = new XMLEditor(this.cde);
            this.sourceIndex = this.cde.addPage((IEditorPart)this.sourceTextEditor, this.cde.getEditorInput());
            this.cde.setPageTextSuper(this.sourceIndex, "Source");
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.cde.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    public String prettyPrintModel() {
        return ((AEDeploymentDescription_Impl)this.aeDD).prettyPrint(MultiPageEditorContributor.getXMLindent());
    }

    public void pageChangeForCurrentEditor(int newPageIndex) {
        if (this.isPageChangeRecursion) {
            return;
        }
        int oldPageIndex = this.cde.getCurrentPageSuper();
        if (oldPageIndex != -1 && oldPageIndex == this.sourceIndex && !this.validateSource()) {
            this.setActivePageWhileBlockingRecursion(this.sourceIndex);
            return;
        }
        this.cde.pageChangeSuper(newPageIndex);
        if (newPageIndex == this.sourceIndex) {
            if (!this.isBadXML) {
                this.updateSourceFromModel();
            }
        } else if (oldPageIndex == this.sourceIndex) {
            if (!this.validateSource()) {
                this.setActivePageWhileBlockingRecursion(this.sourceIndex);
                return;
            }
            this.cde.pageChangeSuper(newPageIndex);
            this.setInput();
            return;
        }
        this.setActivePageWhileBlockingRecursion(newPageIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setActivePageWhileBlockingRecursion(int sourceIndex) {
        try {
            this.isPageChangeRecursion = true;
            this.cde.setActivePageSuper(sourceIndex);
        }
        finally {
            this.isPageChangeRecursion = false;
        }
    }

    public void updateSourceFromModel() {
        this.sourceTextEditor.setIgnoreTextEvent(true);
        IDocument doc = this.sourceTextEditor.getDocumentProvider().getDocument((Object)this.sourceTextEditor.getEditorInput());
        doc.set(this.prettyPrintModel());
        this.sourceTextEditor.setIgnoreTextEvent(false);
    }

    public void switchToBadSource(boolean genSource) {
        this.isBadXML = true;
        if (genSource) {
            this.updateSourceFromModel();
        }
        this.cde.setActivePageSuper(this.sourceIndex);
    }

    protected boolean validateSource() {
        ByteArrayInputStream is;
        this.isBadXML = true;
        IDocument doc = this.sourceTextEditor.getDocumentProvider().getDocument((Object)this.sourceTextEditor.getEditorInput());
        String text = doc.get();
        try {
            is = new ByteArrayInputStream(text.getBytes(this.cde.getCharSet(text)));
        }
        catch (UnsupportedEncodingException e2) {
            Utility.popMessage((String)Messages.getString("MultiPageEditor.19"), (String)this.cde.getMessagesToRootCause((Throwable)e2), (int)1);
            return false;
        }
        String filePathName = this.getFile().getLocation().toString();
        XMLInputSource input = new XMLInputSource((InputStream)is, new File(filePathName));
        try {
            XMLizable inputDescription = UimaDescriptionUtils.parseDescriptor(input);
            if (inputDescription instanceof AEDeploymentDescription) {
                this.aeDD = (AEDeploymentDescription)inputDescription;
                ResourceSpecifier aed = this.aeDD.getAeService().resolveTopAnalysisEngineDescription(this.cde.createResourceManager(), false);
                if (aed instanceof AnalysisEngineDescription && !((AnalysisEngineDescription)aed).isPrimitive()) {
                    this.aeDD.getAeService().getAnalysisEngineDeploymentMetaData().resolveDelegates(this.cde.createResourceManager(), true);
                }
            } else {
                String msg = Messages.getFormattedString("Unrecognized descriptor type for file ''{0}''.", new String[]{AbstractSection.maybeShortenFileName((String)filePathName)}) + "\n";
                Utility.popMessage((String)"Error", (String)msg, (int)1);
                return false;
            }
            this.isBadXML = false;
        }
        catch (InvalidXMLException e) {
            Utility.popMessage((String)Messages.getString("InvalidXMLException"), (String)this.cde.getMessagesToRootCause((Throwable)e), (int)1);
            return false;
        }
        return true;
    }

    public void doSaveForCurrentEditor(IProgressMonitor monitor) {
        if (this.cde.getCurrentPageSuper() != this.sourceIndex) {
            this.updateSourceFromModel();
        }
        this.sourceTextEditor.doSave(monitor);
        this.cde.setFileDirtyFlag(false);
        this.cde.firePropertyChangeSuper(257);
    }

    public void doSaveAsForCurrentEditor() {
        if (this.cde.getCurrentPageSuper() != this.sourceIndex) {
            this.updateSourceFromModel();
        }
        this.cde.setSaveAsStatus(-2);
        this.sourceTextEditor.doSaveAs();
        if (this.cde.m_nSaveAsStatus == -3) {
            this.cde.m_nSaveAsStatus = -1;
            return;
        }
        FileEditorInput newEditorInput = (FileEditorInput)this.sourceTextEditor.getEditorInput();
        this.cde.setInputSuper((IEditorInput)newEditorInput);
        this.cde.firePropertyChangeSuper(258);
        this.cde.setPartNameSuper(newEditorInput.getFile().getName());
        this.cde.firePropertyChangeSuper(1);
        this.cde.setFileDirtyFlag(false);
        this.cde.firePropertyChangeSuper(257);
    }

    public IFile getFile() {
        return this.inputIFile;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public IJavaProject getJavaProject() {
        IFile iFile = this.getFile();
        if (null == this.javaProject && null != iFile) {
            this.javaProject = JavaCore.create((IProject)iFile.getProject());
        }
        return this.javaProject;
    }

    public IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public void openTopLevelXmlDescriptor(Import importItem) {
        this.cde.open(this.cde.getAbsolutePathFromImport(importItem));
    }
}

