/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.nio.charset.Charset;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.resource.BaseDataResource;
import org.apache.wicket.util.string.Strings;

public class CharSequenceResource
extends BaseDataResource<CharSequence> {
    private static final long serialVersionUID = 1L;
    private String charsetName;

    public CharSequenceResource(String contentType) {
        super(contentType);
    }

    public CharSequenceResource(String contentType, CharSequence data) {
        super(contentType, data);
    }

    public CharSequenceResource(String contentType, CharSequence data, String filename) {
        super(contentType, data, filename);
    }

    @Override
    protected void writeData(Response response, CharSequence data) {
        response.write(data);
    }

    @Override
    protected Long getLength(CharSequence data) {
        return Strings.lengthInBytes(data.toString(), this.getCharset());
    }

    protected Charset getCharset() {
        return this.charsetName != null ? Charset.forName(this.charsetName) : null;
    }

    public void setCharset(Charset charset) {
        this.charsetName = charset != null ? charset.name() : null;
    }
}

